<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * SendFox API helper
 */
class TriggerNinja_SendFox_API
{
    const API_BASE = 'https://api.sendfox.com';

    private static function request( $endpoint, $method = 'GET', $data = array(), $api_key = '', $form_id = 0 )
    {
        $url = self::API_BASE . '/' . ltrim( $endpoint, '/' );

        $headers = array(
            'Content-Type'  => 'application/json',
            'Authorization' => 'Bearer ' . $api_key
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'sendfox' );
    }

    public static function api_get_lists( $api_key )
    {
        return self::request( 'lists', 'GET', array(), $api_key );
    }

    public static function api_create_or_update_contact( $api_key, $contact_data, $form_id = 0 )
    {
        return self::request( 'contacts', 'POST', $contact_data, $api_key, $form_id );
    }
}