<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Sender API helper
 */
class TriggerNinja_Sender_API
{
    const API_BASE = 'https://api.sender.net/v2';

    private static function request( $endpoint, $method = 'GET', $data = array(), $api_key = '', $form_id = 0 )
    {
        $url = self::API_BASE . '/' . ltrim( $endpoint, '/' );

        $headers = array(
            'Content-Type'  => 'application/json',
            'Authorization' => 'Bearer ' . $api_key
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'sender' );
    }

    public static function api_get_groups( $api_key )
    {
        return self::request( 'groups', 'GET', array(), $api_key );
    }

    public static function api_create_or_update_contact( $api_key, $contact_data, $form_id = 0 )
    {
        return self::request( 'subscribers', 'POST', $contact_data, $api_key, $form_id );
    }
}