<?php if ( ! defined( 'ABSPATH' ) ) exit;

require_once plugin_dir_path( __FILE__ ) . 'saleshandy-api.php';

class TriggerNinja_SalesHandy extends TriggerNinja_Platform_Abstract
{
    protected $id = 'saleshandy';
    protected $name = 'TN SalesHandy';

    protected function init_api()
    {
        $this->settings['api_key'] = get_option( 'triggerninja_saleshandy_api_key', '' );

        $this->api = new stdClass();
        $this->api->api_key = $this->settings['api_key'];
    }

    public function get_settings_fields()
    {
        return array(
            'triggerninja_saleshandy_api_key' => array(
                'name' => 'triggerninja_saleshandy_api_key',
                'type' => 'text',
                'label' => __( 'Access Token', 'triggerninja-for-ninja-forms' ),
                'default' => ''
            )
        );
    }

    public function get_action_fields()
    {
        $fields = array(
            'list' => array(
                'name' => 'list',
                'type' => 'select',
                'label' => __( 'Sequence', 'triggerninja-for-ninja-forms' ),
                'group' => 'primary',
                'width' => 'full',
                'options' => $this->get_lists()
            )
        );
        return array_merge($fields, $this->get_common_fields());
    }

    public function is_connected()
    {
        return ! empty( $this->api->api_key );
    }

    public function get_lists()
    {
        if ( ! $this->is_connected() ) {
            return array(
                array(
                    'label' => __( 'Please connect to SalesHandy first', 'triggerninja-for-ninja-forms' ),
                    'value' => ''
                )
            );
        }

        $res = TriggerNinja_SalesHandy_API::api_get_sequences( $this->api->api_key );
        if ( $res->status >= 200 && $res->status < 300 ) {
            $lists = array();
            if ( $res->details->payload && is_array( $res->details->payload ) ) {
                foreach ( $res->details->payload as $sequence ) {
                    if ( isset( $sequence->steps ) && is_array( $sequence->steps ) ) {
                        foreach ( $sequence->steps as $step ) {
                            $title = isset( $sequence->title ) ? $sequence->title : '';
                            $step_name = isset( $step->name ) ? $step->name : ( isset( $step['name'] ) ? $step['name'] : '' );
                            $step_id = isset( $step->id ) ? $step->id : ( isset( $step['id'] ) ? $step['id'] : '' );
                            $lists[] = array(
                                'label' => $title . ': ' . $step_name,
                                'value' => $step_id
                            );
                        }
                    }
                }
            }

            array_unshift( $lists, array( 'value' => '', 'label' => '-' ) );
            return $lists;
        }
        return array(
            array(
                'label' => __( 'Error fetching sequences', 'triggerninja-for-ninja-forms' ),
                'value' => ''
            )
        );
    }

    public function process_submission( $action_settings, $form_id, $data )
    {
        if ( ! $this->is_connected() ) {
            return $this->add_debug( $data, 'SalesHandy not connected', 'error' );
        }

        if ( empty( $action_settings['list'] ) ) {
            return $this->add_debug( $data, 'No SalesHandy sequence specified', 'error' );
        }

        $email = $action_settings['email_address'] ?? '';
        $first_name = $action_settings['first_name'] ?? '';
        $last_name = $action_settings['last_name'] ?? '';

        if ( empty( $email ) ) {
            return $this->add_debug( $data, 'No email provided', 'error' );
        }

        $prospect_data = array(
            'prospectList' => array(
                array(
                    'fields' => array(
                        array(
                            'id' => 'email',
                            'value' => $email
                        ),
                        array(
                            'id' => 'firstName',
                            'value' => $first_name
                        ),
                        array(
                            'id' => 'lastName',
                            'value' => $last_name
                        )
                    )
                )
            ),
            'stepId' => $action_settings['list'],
            'verifyProspects' => true,
            'conflictAction' => 'overwrite'
        );

        $res = TriggerNinja_SalesHandy_API::api_add_prospect_to_sequence( $this->api->api_key, $prospect_data, $form_id );

        if ( $res->status >= 200 && $res->status < 300 ) {
            $data = $this->save_submission_data( $data, $res->details );
            return $this->add_debug( $data, 'Prospect sent to SalesHandy', 'success' );
        } else {
            return $this->add_debug( $data, 'SalesHandy API error: ' . $res->error, 'error' );
        }
    }

    public function get_submission_metabox_data( $submission_data )
    {
        return isset( $submission_data['extra'][ $this->get_id() ] ) ? $submission_data['extra'][ $this->get_id() ] : array();
    }
}