<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * SalesHandy API helper
 */
class TriggerNinja_SalesHandy_API
{
    const API_BASE = 'https://leo-open-api-gateway.saleshandy.com';

    private static function request( $endpoint, $method = 'GET', $data = array(), $api_key = '', $form_id = 0 )
    {
        $url = self::API_BASE . '/' . ltrim( $endpoint, '/' );

        $headers = array(
            'Content-Type'  => 'application/json',
            'x-api-key'     => $api_key
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'saleshandy' );
    }

    public static function api_get_sequences( $api_key )
    {
        return self::request( 'v1/sequences?pageSize=1000&page=1&sort=ASC&sortBy=sequence.createdAt', 'GET', array(), $api_key );
    }

    public static function api_add_prospect_to_sequence( $api_key, $prospect_data, $form_id = 0 )
    {
        return self::request( 'v1/prospects/import', 'POST', $prospect_data, $api_key, $form_id );
    }
}