<?php if ( ! defined( 'ABSPATH' ) ) exit;

require_once plugin_dir_path( __FILE__ ) . 'rapidmail-api.php';

class TriggerNinja_Rapidmail extends TriggerNinja_Platform_Abstract
{
    protected $id = 'rapidmail';
    protected $name = 'TN Rapidmail';

    protected function init_api()
    {
        $this->settings['username'] = get_option( 'triggerninja_rapidmail_username', '' );
        $this->settings['password'] = get_option( 'triggerninja_rapidmail_password', '' );

        $this->api = new stdClass();
        $this->api->username = $this->settings['username'];
        $this->api->password = $this->settings['password'];
    }

    public function get_settings_fields()
    {
        return array(
            'triggerninja_rapidmail_username' => array(
                'name' => 'triggerninja_rapidmail_username',
                'type' => 'text',
                'label' => __( 'Username', 'triggerninja-for-ninja-forms' ),
                'default' => ''
            ),
            'triggerninja_rapidmail_password' => array(
                'name' => 'triggerninja_rapidmail_password',
                'type' => 'password',
                'label' => __( 'Password', 'triggerninja-for-ninja-forms' ),
                'default' => ''
            )
        );
    }

    public function get_action_fields()
    {
        $fields = array(
            'list' => array(
                'name' => 'list',
                'type' => 'select',
                'label' => __( 'List', 'triggerninja-for-ninja-forms' ),
                'group' => 'primary',
                'width' => 'full',
                'options' => $this->get_lists()
            )
        );
        return array_merge($fields, $this->get_common_fields());
    }

    public function is_connected()
    {
        return ! empty( $this->api->username ) && ! empty( $this->api->password );
    }

    public function get_lists()
    {
        if ( ! $this->is_connected() ) {
            return array(
                array(
                    'label' => __( 'Please connect to Rapidmail first', 'triggerninja-for-ninja-forms' ),
                    'value' => ''
                )
            );
        }

        $res = TriggerNinja_Rapidmail_API::api_get_lists( $this->api->username, $this->api->password );
        if ( $res->status >= 200 && $res->status < 300 ) {
            $lists = array();
            if ( $res->details->_embedded->recipientlists && is_array( $res->details->_embedded->recipientlists ) ) {
                foreach ( $res->details->_embedded->recipientlists as $list ) {
                    $lists[] = array(
                        'label' => $list->name,
                        'value' => $list->id
                    );
                }
            }
            return $lists;
        }
        return array(
            array(
                'label' => __( 'Error fetching lists', 'triggerninja-for-ninja-forms' ),
                'value' => ''
            )
        );
    }

    public function process_submission( $action_settings, $form_id, $data )
    {
        if ( ! $this->is_connected() ) {
            return $this->add_debug( $data, 'Rapidmail not connected', 'error' );
        }

        if ( empty( $action_settings['list'] ) ) {
            return $this->add_debug( $data, 'No Rapidmail list specified', 'error' );
        }

        $email = $action_settings['email_address'] ?? '';
        $first_name = $action_settings['first_name'] ?? '';
        $last_name = $action_settings['last_name'] ?? '';

        if ( empty( $email ) ) {
            return $this->add_debug( $data, 'No email provided', 'error' );
        }

        $contact_data = array(
            'recipientlist_id' => $action_settings['list'],
            'email' => $email,
            'firstname' => $first_name,
            'lastname' => $last_name
        );

        $find_res = TriggerNinja_Rapidmail_API::api_find_contact( $this->api->username, $this->api->password, $email, $action_settings['list'] );

        if ( $find_res->status >= 200 && $find_res->status < 300 && ! empty( $find_res->details->_embedded->recipients[0]->id ) ) {
            $recipient_id = $find_res->details->_embedded->recipients[0]->id;
            unset( $contact_data['recipientlist_id'] );
            $res = TriggerNinja_Rapidmail_API::api_update_contact( $this->api->username, $this->api->password, $recipient_id, $contact_data, $form_id );
        } else {
            $res = TriggerNinja_Rapidmail_API::api_create_contact( $this->api->username, $this->api->password, $contact_data, $form_id );
        }

        if ( $res->status >= 200 && $res->status < 300 ) {
            $data = $this->save_submission_data( $data, $res->details );
            return $this->add_debug( $data, 'Contact sent to Rapidmail', 'success' );
        } else {
            return $this->add_debug( $data, 'Rapidmail API error: ' . $res->error, 'error' );
        }
    }

    public function get_submission_metabox_data( $submission_data )
    {
        return isset( $submission_data['extra'][ $this->get_id() ] ) ? $submission_data['extra'][ $this->get_id() ] : array();
    }
}