<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Rapidmail API helper
 */
class TriggerNinja_Rapidmail_API
{
    const API_BASE = 'https://apiv3.emailsys.net';

    private static function request( $endpoint, $method = 'GET', $data = array(), $username = '', $password = '', $form_id = 0 )
    {
        $url = self::API_BASE . '/' . ltrim( $endpoint, '/' );

        $headers = array(
            'Content-Type'  => 'application/json',
            'Authorization' => 'Basic ' . base64_encode( $username . ':' . $password )
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'rapidmail' );
    }

    public static function api_get_lists( $username, $password )
    {
        return self::request( 'recipientlists', 'GET', array(), $username, $password );
    }

    public static function api_find_contact( $username, $password, $email, $list_id )
    {
        $endpoint = 'recipients?email=' . urlencode( $email ) . '&recipientlist_id=' . urlencode( $list_id );
        return self::request( $endpoint, 'GET', array(), $username, $password );
    }

    public static function api_create_contact( $username, $password, $contact_data, $form_id = 0 )
    {
        return self::request( 'recipients', 'POST', $contact_data, $username, $password, $form_id );
    }

    public static function api_update_contact( $username, $password, $recipient_id, $contact_data, $form_id = 0 )
    {
        return self::request( 'recipients/' . $recipient_id, 'PATCH', $contact_data, $username, $password, $form_id );
    }
}