<?php if ( ! defined( 'ABSPATH' ) ) exit;

require_once plugin_dir_path( __FILE__ ) . 'mailwizz-api.php';

class TriggerNinja_MailWizz extends TriggerNinja_Platform_Abstract
{
    protected $id = 'mailwizz';
    protected $name = 'TN MailWizz';

    protected function init_api()
    {
        $this->settings['api_url'] = get_option( 'triggerninja_mailwizz_api_url', '' );
        $this->settings['api_key'] = get_option( 'triggerninja_mailwizz_api_key', '' );

        $this->api = new stdClass();
        $this->api->api_url = $this->settings['api_url'];
        $this->api->api_key = $this->settings['api_key'];
    }

    public function get_settings_fields()
    {
        return array(
            'triggerninja_mailwizz_api_url' => array(
                'name' => 'triggerninja_mailwizz_api_url',
                'type' => 'text',
                'label' => __( 'API URL', 'triggerninja-for-ninja-forms' ),
                'default' => ''
            ),
            'triggerninja_mailwizz_api_key' => array(
                'name' => 'triggerninja_mailwizz_api_key',
                'type' => 'text',
                'label' => __( 'API Key', 'triggerninja-for-ninja-forms' ),
                'default' => ''
            )
        );
    }

    public function get_action_fields()
    {
        $fields = array(
            'list' => array(
                'name' => 'list',
                'type' => 'select',
                'label' => __( 'List', 'triggerninja-for-ninja-forms' ),
                'group' => 'primary',
                'width' => 'full',
                'options' => $this->get_lists()
            )
        );
        return array_merge($fields, $this->get_common_fields());
    }

    public function is_connected()
    {
        return ! empty( $this->api->api_url ) && ! empty( $this->api->api_key );
    }

    public function get_lists()
    {
        if ( ! $this->is_connected() ) {
            return array(
                array(
                    'label' => __( 'Please connect to MailWizz first', 'triggerninja-for-ninja-forms' ),
                    'value' => ''
                )
            );
        }

        $res = TriggerNinja_MailWizz_API::api_get_lists( $this->api->api_url, $this->api->api_key );
        if ( $res->status >= 200 && $res->status < 300 ) {
            $lists = array();
            if ( $res->details->records && is_array( $res->details->records ) ) {
                foreach ( $res->details->records as $list ) {
                    $lists[] = array(
                        'label' => $list->general->display_name,
                        'value' => $list->general->list_uid
                    );
                }
            }
            return $lists;
        }
        return array(
            array(
                'label' => __( 'Error fetching lists', 'triggerninja-for-ninja-forms' ),
                'value' => ''
            )
        );
    }

    public function process_submission( $action_settings, $form_id, $data )
    {
        if ( ! $this->is_connected() ) {
            return $this->add_debug( $data, 'MailWizz not connected', 'error' );
        }

        if ( empty( $action_settings['list'] ) ) {
            return $this->add_debug( $data, 'No MailWizz list specified', 'error' );
        }

        $email = $action_settings['email_address'] ?? '';
        $first_name = $action_settings['first_name'] ?? '';
        $last_name = $action_settings['last_name'] ?? '';

        if ( empty( $email ) ) {
            return $this->add_debug( $data, 'No email provided', 'error' );
        }

        $contact_data = array(
            'EMAIL' => trim( $email ),
            'FNAME' => $first_name,
            'LNAME' => $last_name
        );

        $res = TriggerNinja_MailWizz_API::api_create_or_update_contact( $this->api->api_url, $this->api->api_key, $action_settings['list'], $contact_data, $form_id );

        if ( $res->status >= 200 && $res->status < 300 ) {
            $data = $this->save_submission_data( $data, $res->details );
            return $this->add_debug( $data, 'Contact sent to MailWizz', 'success' );
        } else {
            return $this->add_debug( $data, 'MailWizz API error: ' . $res->error, 'error' );
        }
    }

    public function get_submission_metabox_data( $submission_data )
    {
        return isset( $submission_data['extra'][ $this->get_id() ] ) ? $submission_data['extra'][ $this->get_id() ] : array();
    }
}