<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * MailWizz API helper
 */
class TriggerNinja_MailWizz_API
{
    private static function request( $endpoint, $method = 'GET', $data = array(), $api_url = '', $api_key = '', $form_id = 0 )
    {
        $url = rtrim( $api_url, '/' ) . '/' . ltrim( $endpoint, '/' );

        $headers = array(
            'Content-Type'    => 'application/x-www-form-urlencoded',
            'X-MW-PUBLIC-KEY' => $api_key,
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'mailwizz' );
    }

    public static function api_get_lists( $api_url, $api_key )
    {
        return self::request( 'lists?page=1&per_page=50', 'GET', array(), $api_url, $api_key );
    }

    public static function api_create_or_update_contact( $api_url, $api_key, $list_id, $contact_data, $form_id = 0 )
    {
        $endpoint = "lists/{$list_id}/subscribers";
        return self::request( $endpoint, 'POST', $contact_data, $api_url, $api_key, $form_id );
    }
}