<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * MailRelay API helper
 */
class TriggerNinja_MailRelay_API
{
    private static function get_api_base( $subdomain )
    {
        return "https://{$subdomain}.ipzmarketing.com/api/v1";
    }

    private static function request( $endpoint, $method = 'GET', $data = array(), $subdomain = '', $api_key = '', $form_id = 0 )
    {
        $url = self::get_api_base( $subdomain ) . '/' . ltrim( $endpoint, '/' );

        $headers = array(
            'Content-Type'  => 'application/json',
            'X-AUTH-TOKEN' => $api_key
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'mailrelay' );
    }

    public static function api_get_groups( $subdomain, $api_key )
    {
        return self::request( 'groups?per_page=1000', 'GET', array(), $subdomain, $api_key );
    }

    public static function api_create_or_update_contact( $subdomain, $api_key, $contact_data, $form_id = 0 )
    {
        return self::request( 'subscribers/sync', 'POST', $contact_data, $subdomain, $api_key, $form_id );
    }
}