<?php if ( ! defined( 'ABSPATH' ) ) exit;

require_once plugin_dir_path( __FILE__ ) . 'mailjet-api.php';

class TriggerNinja_Mailjet extends TriggerNinja_Platform_Abstract
{
    protected $id = 'mailjet';
    protected $name = 'TN Mailjet';

    protected function init_api()
    {
        $this->settings['api_key'] = get_option( 'triggerninja_mailjet_api_key', '' );
        $this->settings['secret_key'] = get_option( 'triggerninja_mailjet_secret_key', '' );

        $this->api = new stdClass();
        $this->api->api_key = $this->settings['api_key'];
        $this->api->secret_key = $this->settings['secret_key'];
    }

    public function get_settings_fields()
    {
        return array(
            'triggerninja_mailjet_api_key' => array(
                'name' => 'triggerninja_mailjet_api_key',
                'type' => 'text',
                'label' => __( 'API Key', 'triggerninja-for-ninja-forms' ),
                'default' => ''
            ),
            'triggerninja_mailjet_secret_key' => array(
                'name' => 'triggerninja_mailjet_secret_key',
                'type' => 'password',
                'label' => __( 'Secret Key', 'triggerninja-for-ninja-forms' ),
                'default' => ''
            )
        );
    }

    public function get_action_fields()
    {
        $common_fields = $this->get_common_fields();
        unset( $common_fields['first_name'] );
        unset( $common_fields['last_name'] );

        $common_fields['name'] = array(
            'name' => 'name',
            'type' => 'textbox',
            'label' => __( 'Name', 'triggerninja-for-ninja-forms' ),
            'group' => 'primary',
            'width' => 'full',
            'use_merge_tags' => true
        );

        $fields = array(
            'list_id' => array(
                'name' => 'list_id',
                'type' => 'select',
                'label' => __( 'List', 'triggerninja-for-ninja-forms' ),
                'group' => 'primary',
                'width' => 'full',
                'options' => $this->get_lists()
            )
        );
        return array_merge($fields, $common_fields);
    }


    public function is_connected()
    {
        return ! empty( $this->api->api_key ) && ! empty( $this->api->secret_key );
    }

    public function get_lists()
    {
        if ( ! $this->is_connected() ) {
            return array(
                array(
                    'label' => __( 'Please connect to Mailjet first', 'triggerninja-for-ninja-forms' ),
                    'value' => ''
                )
            );
        }

        $res = TriggerNinja_Mailjet_API::api_get_lists( $this->api->api_key, $this->api->secret_key );
        if ( $res->status >= 200 && $res->status < 300 ) {
            $lists = array();
            if ( ! empty( $res->details->Data ) ) {
                foreach ( $res->details->Data as $list ) {
                    $lists[] = array(
                        'label' => $list->Name,
                        'value' => $list->ID
                    );
                }
            }
            return $lists;
        }
        return array(
            array(
                'label' => __( 'Error fetching lists', 'triggerninja-for-ninja-forms' ),
                'value' => ''
            )
        );
    }

    public function process_submission( $action_settings, $form_id, $data )
    {
        if ( empty( $this->api->api_key ) || empty( $this->api->secret_key ) ) {
            return $this->add_debug( $data, 'Mailjet API key or secret key not configured', 'error' );
        }

        if ( empty( $action_settings['list_id'] ) ) {
            return $this->add_debug( $data, 'No Mailjet list specified', 'error' );
        }

        $email = $action_settings['email_address'] ?? '';
        $name = $action_settings['name'] ?? '';

        if ( empty( $email ) ) {
            return $this->add_debug( $data, 'No email provided', 'error' );
        }

        $subscriber_data = array(
            'Contacts' => array(
                array(
                    'Email' => trim( $email ),
                    'IsExcludedFromCampaigns' => false,
                    'Properties' => array(
                        'Name' => $name
                    )
                )
            ),
            'ContactsLists' => array(
                array(
                    'ListID' => $action_settings['list_id'],
                    'Action' => 'addforce'
                )
            )
        );

        $res = TriggerNinja_Mailjet_API::api_create_or_update_contact( $this->api->api_key, $this->api->secret_key, $subscriber_data, $form_id );

        if ( $res->status >= 200 && $res->status < 300 ) {
            $data = $this->save_submission_data( $data, $res->details );
            return $this->add_debug( $data, 'Contact sent to Mailjet', 'success' );
        } else {
            return $this->add_debug( $data, 'Mailjet API error: ' . $res->error, 'error' );
        }
    }

    public function get_submission_metabox_data( $submission_data )
    {
        return isset( $submission_data['extra'][ $this->get_id() ] ) ? $submission_data['extra'][ $this->get_id() ] : array();
    }
}