<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Mailjet API helper
 */
class TriggerNinja_Mailjet_API
{
    const API_BASE = 'https://api.mailjet.com/v3/REST';

    private static function request( $endpoint, $method = 'GET', $data = array(), $api_key = '', $secret_key = '', $form_id = 0 )
    {
        $url = self::API_BASE . '/' . $endpoint;

        $headers = array(
            'Content-Type'  => 'application/json',
            'Authorization' => 'Basic ' . base64_encode( $api_key . ':' . $secret_key )
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'mailjet' );
    }

    public static function api_get_lists( $api_key, $secret_key )
    {
        return self::request( 'contactslist?limit=1000', 'GET', array(), $api_key, $secret_key );
    }

    public static function api_create_or_update_contact( $api_key, $secret_key, $contact_data, $form_id = 0 )
    {
        return self::request( 'contact/managemanycontacts', 'POST', $contact_data, $api_key, $secret_key, $form_id );
    }
}