<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Mailercloud API helper
 */
class TriggerNinja_Mailercloud_API
{
    const API_BASE = 'https://cloudapi.mailercloud.com/v1';

    private static function request( $endpoint, $method = 'GET', $data = array(), $api_key = '', $form_id = 0 )
    {
        $url = self::API_BASE . '/' . ltrim( $endpoint, '/' );

        $headers = array(
            'Content-Type' => 'application/json',
            'Authorization' => $api_key,
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'mailercloud' );
    }

    public static function api_get_lists( $api_key )
    {
        return self::request( 'lists/search', 'POST', array( 'limit' => 100, 'page' => 1 ), $api_key );
    }

    public static function api_create_or_update_contact( $api_key, $contact_data, $form_id = 0 )
    {
        return self::request( 'contacts', 'POST', $contact_data, $api_key, $form_id );
    }

    public static function api_update_contact( $api_key, $email, $contact_data, $form_id = 0 )
    {
        return self::request( 'contacts/' . $email, 'PUT', $contact_data, $api_key, $form_id );
    }
}