<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Mailcoach API helper
 */
class TriggerNinja_Mailcoach_API
{
    private static function get_api_base( $api_url )
    {
        $base_url = rtrim( $api_url, '/' ) . '/api';
        if ( strpos( $base_url, 'https://' ) === false ) {
            $base_url = 'https://' . $base_url;
        }
        return $base_url;
    }

    private static function request( $endpoint, $method = 'GET', $data = array(), $api_url = '', $api_token = '', $form_id = 0 )
    {
        $url = self::get_api_base( $api_url ) . '/' . ltrim( $endpoint, '/' );

        $headers = array(
            'Authorization' => 'Bearer ' . $api_token,
            'Content-Type'  => 'application/json'
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'mailcoach' );
    }

    public static function api_get_lists( $api_url, $api_token )
    {
        return self::request( 'email-lists', 'GET', array(), $api_url, $api_token );
    }

    public static function api_create_or_update_contact( $api_url, $api_token, $list_id, $contact_data, $form_id = 0 )
    {
        $endpoint = "email-lists/{$list_id}/subscribers";
        return self::request( $endpoint, 'POST', $contact_data, $api_url, $api_token, $form_id );
    }
}