<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Loops API helper
 */
class TriggerNinja_Loops_API
{
    const API_BASE = 'https://app.loops.so/api/v1';

    private static function request( $endpoint, $method = 'GET', $data = array(), $api_key = '', $form_id = 0 )
    {
        $url = self::API_BASE . '/' . ltrim( $endpoint, '/' );

        $headers = array(
            'Content-Type'  => 'application/json',
            'Authorization' => 'Bearer ' . $api_key
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'loops' );
    }

    public static function api_get_lists( $api_key )
    {
        return self::request( 'lists', 'GET', array(), $api_key );
    }

    public static function api_find_contact( $api_key, $email )
    {
        return self::request( 'contacts/find?email=' . urlencode( $email ), 'GET', array(), $api_key );
    }

    public static function api_create_contact( $api_key, $contact_data, $form_id = 0 )
    {
        return self::request( 'contacts/create', 'POST', $contact_data, $api_key, $form_id );
    }

    public static function api_update_contact( $api_key, $contact_data, $form_id = 0 )
    {
        return self::request( 'contacts/update', 'PUT', $contact_data, $api_key, $form_id );
    }
}