<?php if ( ! defined( 'ABSPATH' ) ) exit;

class TriggerNinja_Kit_API
{
    const URL = 'https://api.kit.com/v4/';
    private $api_key;
    private $form_id;

    public function __construct( $api_key = '', $form_id = 0 )
    {
        $this->api_key = $api_key;
        $this->form_id = $form_id;
    }

    public function request( $endpoint, $method = 'GET', $data = array() )
    {
        $url = trailingslashit( self::URL ) . $endpoint;
        
        $headers = array(
            'X-Kit-Api-Key' => $this->api_key
        );
        
        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $this->form_id, 'kit' );
    }

    /**
     * Create a subscriber
     * 
     * @param string $email Email address
     * @param string $first_name First name
     * @param string $state State (active, inactive)
     * @return TriggerNinja_Response
     */
    public function create_subscriber( $email, $first_name = '', $state = 'active' )
    {
        $subscriber_data = array_filter( array(
            'email_address' => trim( $email ),
            'first_name' => $first_name,
            'state' => $state
        ) );

        return $this->request( 'subscribers', 'POST', $subscriber_data );
    }

    /**
     * Subscribe to sequence
     * 
     * @param string $sequence_id Sequence ID
     * @param string $email Email address
     * @return TriggerNinja_Response
     */
    public function subscribe_to_sequence( $sequence_id, $email )
    {
        $data = array(
            'email_address' => trim( $email )
        );

        return $this->request( "sequences/{$sequence_id}/subscribers", 'POST', $data );
    }

    /**
     * Subscribe to form
     * 
     * @param string $form_id Form ID
     * @param string $email Email address
     * @return TriggerNinja_Response
     */
    public function subscribe_to_form( $form_id, $email )
    {
        $data = array(
            'email_address' => trim( $email )
        );

        return $this->request( "forms/{$form_id}/subscribers", 'POST', $data );
    }

    /**
     * Get sequences
     * 
     * @return TriggerNinja_Response
     */
    public function get_sequences()
    {
        return $this->request( 'sequences' );
    }

    /**
     * Get forms
     * 
     * @return TriggerNinja_Response
     */
    public function get_forms()
    {
        return $this->request( 'forms' );
    }

    /**
     * Get account info for connection testing
     * 
     * @return TriggerNinja_Response
     */
    public function get_account_info()
    {
        return $this->request( 'account' );
    }
}