<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * GoHighLevel API helper
 */
class TriggerNinja_GoHighLevel_API
{
    const API_BASE = 'https://rest.gohighlevel.com/v1';

    private static function request( $endpoint, $method = 'GET', $data = array(), $api_key = '', $form_id = 0 )
    {
        $url = self::API_BASE . '/' . ltrim( $endpoint, '/' );

        $headers = array(
            'Content-Type'  => 'application/json',
            'Authorization' => 'Bearer ' . $api_key
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'gohighlevel' );
    }

    public static function api_create_or_update_contact( $api_key, $contact_data, $form_id = 0 )
    {
        return self::request( 'contacts', 'POST', $contact_data, $api_key, $form_id );
    }
}