<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Flodesk API helper
 */
class TriggerNinja_Flodesk_API
{
    const API_BASE = 'https://api.flodesk.com/v1';

    private static function request( $endpoint, $method = 'GET', $data = array(), $api_key = '', $form_id = 0 )
    {
        $url = self::API_BASE . '/' . ltrim( $endpoint, '/' );

        $headers = array(
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
            'Authorization' => 'Basic ' . base64_encode( $api_key . ':' )
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'flodesk' );
    }

    public static function api_get_segments( $api_key )
    {
        return self::request( 'segments', 'GET', array(), $api_key );
    }

    public static function api_create_or_update_contact( $api_key, $contact_data, $form_id = 0 )
    {
        return self::request( 'subscribers', 'POST', $contact_data, $api_key, $form_id );
    }

    public static function api_add_to_segment( $api_key, $email, $segment_id, $form_id = 0 )
    {
        $endpoint = "subscribers/{$email}/segments";
        $data = array(
            'segment_ids' => array( $segment_id )
        );
        return self::request( $endpoint, 'POST', $data, $api_key, $form_id );
    }
}