<?php if ( ! defined( 'ABSPATH' ) ) exit;

require_once plugin_dir_path( __FILE__ ) . 'engagebay-api.php';

class TriggerNinja_EngageBay extends TriggerNinja_Platform_Abstract
{
    protected $id = 'engagebay';
    protected $name = 'TN EngageBay';

    protected function init_api()
    {
        $this->settings['api_key'] = get_option( 'triggerninja_engagebay_api_key', '' );

        $this->api = new stdClass();
        $this->api->api_key = $this->settings['api_key'];
    }

    public function get_settings_fields()
    {
        return array(
            'triggerninja_engagebay_api_key' => array(
                'name' => 'triggerninja_engagebay_api_key',
                'type' => 'text',
                'label' => __( 'API Key', 'triggerninja-for-ninja-forms' ),
                'default' => ''
            )
        );
    }

    public function get_action_fields()
    {
        $fields = array(
            'list' => array(
                'name' => 'list',
                'type' => 'select',
                'label' => __( 'List', 'triggerninja-for-ninja-forms' ),
                'group' => 'primary',
                'width' => 'full',
                'options' => $this->get_lists()
            )
        );
        return array_merge($fields, $this->get_common_fields());
    }

    public function is_connected()
    {
        return ! empty( $this->api->api_key );
    }

    public function get_lists()
    {
        if ( ! $this->is_connected() ) {
            return array(
                array(
                    'label' => __( 'Please connect to EngageBay first', 'triggerninja-for-ninja-forms' ),
                    'value' => ''
                )
            );
        }

        $res = TriggerNinja_EngageBay_API::api_get_lists( $this->api->api_key );
        if ( $res->status >= 200 && $res->status < 300 ) {
            $lists = array();
            if ( $res->details && is_array( $res->details ) ) {
                foreach ( $res->details as $list ) {
                    $lists[] = array(
                        'label' => $list->name,
                        'value' => $list->id
                    );
                }
            }
            
            array_unshift( $lists, array( 'value' => '', 'label' => '-' ) );
            
            return $lists;
        }
        return array(
            array(
                'label' => __( 'Error fetching lists', 'triggerninja-for-ninja-forms' ),
                'value' => ''
            )
        );
    }

    public function process_submission( $action_settings, $form_id, $data )
    {
        if ( ! $this->is_connected() ) {
            return $this->add_debug( $data, 'EngageBay not connected', 'error' );
        }

        $email = $action_settings['email_address'] ?? '';
        $first_name = $action_settings['first_name'] ?? '';
        $last_name = $action_settings['last_name'] ?? '';

        if ( empty( $email ) ) {
            return $this->add_debug( $data, 'No email provided', 'error' );
        }

        $contact_data = array(
            'properties' => array(
                array(
                    'name' => 'email',
                    'value' => $email
                ),
                array(
                    'name'  => 'name',
                    'value' => $first_name
                ),
                array(
                    'name' => 'last_name',
                    'value' => $last_name
                )
            )
        );

        if ( ! empty( $action_settings['list'] ) ) {
            $contact_data['listIds'] = array( $action_settings['list'] );
        }

        $res = TriggerNinja_EngageBay_API::api_create_or_update_contact( $this->api->api_key, $contact_data, $form_id );

        if ( $res->status >= 200 && $res->status < 300 ) {
            $data = $this->save_submission_data( $data, $res->details );
            return $this->add_debug( $data, 'Contact sent to EngageBay', 'success' );
        } else {
            return $this->add_debug( $data, 'EngageBay API error: ' . $res->error, 'error' );
        }
    }

    public function get_submission_metabox_data( $submission_data )
    {
        return isset( $submission_data['extra'][ $this->get_id() ] ) ? $submission_data['extra'][ $this->get_id() ] : array();
    }
}