<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * EngageBay API helper
 */
class TriggerNinja_EngageBay_API
{
    const API_BASE = 'https://app.engagebay.com/dev/api';

    private static function request( $endpoint, $method = 'GET', $data = array(), $api_key = '', $form_id = 0 )
    {
        $url = self::API_BASE . '/' . ltrim( $endpoint, '/' );

        $headers = array(
            'Content-Type'  => 'application/json',
            'Accept'        => 'application/json',
            'Authorization' => $api_key
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'engagebay' );
    }

    public static function api_get_lists( $api_key )
    {
        return self::request( 'panel/contactlist', 'GET', array(), $api_key );
    }

    public static function api_create_or_update_contact( $api_key, $contact_data, $form_id = 0 )
    {
        return self::request( 'panel/subscribers/subscriber', 'POST', $contact_data, $api_key, $form_id );
    }
}