<?php if ( ! defined( 'ABSPATH' ) ) exit;

class TriggerNinja_EmailOctopus_API
{
    const URL = 'https://emailoctopus.com/api/1.6/';
    private $api_key;
    private $form_id;

    public function __construct( $api_key = '', $form_id = 0 )
    {
        $this->api_key = $api_key;
        $this->form_id = $form_id;
    }

    public function request( $method, $endpoint, $data = array() )
    {
        $url = trailingslashit( self::URL ) . $endpoint;

        $method = strtoupper( $method );

        if ( $method === 'POST' ) {
            // For POST requests include api_key in the request body
            if ( ! is_array( $data ) ) {
                $data = array();
            }
            $data['api_key'] = $this->api_key;
        }

        // For GET requests, add data as query parameters
        if ( $method === 'GET' && ! empty( $data ) ) {
            $url = add_query_arg( $data, $url );
            $data = array(); // Clear data since it's in URL now
        }

        return TriggerNinja_Http_Client::request( $method, $url, $data, array(), array(), $this->form_id, 'emailoctopus' );
    }

    
    /**
     * Subscribe contact to a list with double opt-in support
     * 
     * @param string $list_id List ID
     * @param string $email Email address
     * @param array $fields Optional fields (first_name, last_name, etc.)
     * @param bool $double_opt_in Whether to send double opt-in email
     * @return TriggerNinja_Response
     */
    public function subscribe_to_list( $list_id, $email, $fields = array(), $double_opt_in = false )
    {
        $subscription_data = array(
            'email_address' => trim( $email )
        );
        
        // Add fields if provided
        if( !empty( $fields ) ) {
            $subscription_data['fields'] = $fields;
        }
        
        // Set status based on double opt-in preference
        // If double opt-in is enabled, omit status so API defaults to "PENDING"
        // Otherwise set to "SUBSCRIBED"
        if( !$double_opt_in ) {
            $subscription_data['status'] = 'SUBSCRIBED';
        }

        return $this->request( 'POST', "lists/{$list_id}/contacts", $subscription_data );
    }

    /**
     * Get lists
     * 
     * @return TriggerNinja_Response
     */
    public function get_lists()
    {
        return $this->request( 'GET', 'lists' );
    }

    /**
     * Get account info for connection testing
     * 
     * @return TriggerNinja_Response
     */
    public function get_account_info()
    {
        return $this->request( 'GET', 'lists' );
    }
}
