<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Elastic Email API helper
 */
class TriggerNinja_ElasticEmail_API
{
    const API_BASE = 'https://api.elasticemail.com/v2';

    private static function request( $endpoint, $method = 'GET', $data = array(), $api_key = '', $form_id = 0 )
    {
        $url = self::API_BASE . '/' . ltrim( $endpoint, '/' ) . '?apikey=' . $api_key;

        $headers = array(
            'Content-Type' => 'application/x-www-form-urlencoded'
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'elasticemail' );
    }

    public static function api_get_account( $api_key )
    {
        return self::request( 'account/load', 'GET', array(), $api_key );
    }

    public static function api_get_lists( $api_key )
    {
        return self::request( 'list/list', 'GET', array(), $api_key );
    }

    public static function api_create_or_update_contact( $api_key, $contact_data, $form_id = 0 )
    {
        return self::request( 'contact/add', 'POST', $contact_data, $api_key, $form_id );
    }
}