<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * DirectIQ API helper
 */
class TriggerNinja_DirectIQ_API
{
    const API_BASE = 'https://rest.directiq.com';

    private static function request( $endpoint, $method = 'GET', $data = array(), $api_key = '', $api_secret = '', $form_id = 0 )
    {
        $url = self::API_BASE . '/' . ltrim( $endpoint, '/' );

        $headers = array(
            'Content-Type'  => 'application/json',
            'Authorization' => 'Basic ' . base64_encode( $api_key . ':' . $api_secret )
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'directiq' );
    }

    public static function api_get_lists( $api_key, $api_secret )
    {
        return self::request( 'contacts/lists/list', 'GET', array(), $api_key, $api_secret );
    }

    public static function api_create_or_update_contact( $api_key, $api_secret, $list_id, $contact_data, $form_id = 0 )
    {
        $payload = array(
            'listId' => $list_id,
            'email' => $contact_data['Email'],
            'firstName' => $contact_data['FirstName'],
            'lastName' => $contact_data['LastName']
        );
        return self::request( 'subscription/subscribe', 'POST', $payload, $api_key, $api_secret, $form_id );
    }
}