<?php if ( ! defined( 'ABSPATH' ) ) exit;

require_once plugin_dir_path( __FILE__ ) . 'companyhub-api.php';

class TriggerNinja_CompanyHub extends TriggerNinja_Platform_Abstract
{
    protected $id = 'companyhub';
    protected $name = 'TN CompanyHub';

    protected function init_api()
    {
        $this->settings['subdomain'] = get_option( 'triggerninja_companyhub_subdomain', '' );
        $this->settings['api_key'] = get_option( 'triggerninja_companyhub_api_key', '' );

        $this->api = new stdClass();
        $this->api->subdomain = $this->settings['subdomain'];
        $this->api->api_key = $this->settings['api_key'];
    }

    public function get_settings_fields()
    {
        return array(
            'triggerninja_companyhub_subdomain' => array(
                'name' => 'triggerninja_companyhub_subdomain',
                'type' => 'text',
                'label' => __( 'Subdomain', 'triggerninja-for-ninja-forms' ),
                'default' => ''
            ),
            'triggerninja_companyhub_api_key' => array(
                'name' => 'triggerninja_companyhub_api_key',
                'type' => 'text',
                'label' => __( 'API Key', 'triggerninja-for-ninja-forms' ),
                'default' => ''
            )
        );
    }

    public function get_action_fields()
    {
        return $this->get_common_fields();
    }

    public function is_connected()
    {
        return ! empty( $this->api->subdomain ) && ! empty( $this->api->api_key );
    }

    public function get_lists()
    {
        return array();
    }

    public function process_submission( $action_settings, $form_id, $data )
    {
        if ( ! $this->is_connected() ) {
            return $this->add_debug( $data, 'CompanyHub not connected', 'error' );
        }

        $email = $action_settings['email_address'] ?? '';
        $first_name = $action_settings['first_name'] ?? '';
        $last_name = $action_settings['last_name'] ?? '';

        if ( empty( $email ) ) {
            return $this->add_debug( $data, 'No email provided', 'error' );
        }

        $contact_data = array(
            'Email'     => $email,
            'FirstName' => $first_name,
            'LastName'  => $last_name
        );

        $res = TriggerNinja_CompanyHub_API::api_create_contact( $this->api->subdomain, $this->api->api_key, $contact_data, $form_id );

        if ( $res->status >= 200 && $res->status < 300 ) {
            $data = $this->save_submission_data( $data, $res->details );
            return $this->add_debug( $data, 'Contact sent to CompanyHub', 'success' );
        } else {
            return $this->add_debug( $data, 'CompanyHub API error: ' . $res->error, 'error' );
        }
    }

    public function get_submission_metabox_data( $submission_data )
    {
        return isset( $submission_data['extra'][ $this->get_id() ] ) ? $submission_data['extra'][ $this->get_id() ] : array();
    }
}