<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * CompanyHub API helper
 */
class TriggerNinja_CompanyHub_API
{
    const API_BASE = 'https://api.companyhub.com/v1';

    private static function request( $endpoint, $method = 'GET', $data = array(), $subdomain = '', $api_key = '', $form_id = 0 )
    {
        $url = self::API_BASE . '/' . ltrim( $endpoint, '/' );

        $headers = array(
            'Content-Type'  => 'application/json',
            'Authorization' => $subdomain . ' ' . $api_key
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'companyhub' );
    }

    public static function api_create_contact( $subdomain, $api_key, $contact_data, $form_id = 0 )
    {
        return self::request( 'tables/contact', 'POST', $contact_data, $subdomain, $api_key, $form_id );
    }
}