<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Campayn API helper
 */
class TriggerNinja_Campayn_API
{
    const API_BASE = 'https://campayn.com/api/v1';

    private static function request( $endpoint, $method = 'GET', $data = array(), $api_key = '', $form_id = 0 )
    {
        $url = self::API_BASE . '/' . ltrim( $endpoint, '/' );

        $headers = array(
            'Accept'        => 'application/json',
            'Content-Type'  => 'application/json',
            'Authorization' => 'TRUEREST apikey=' . $api_key,
        );

        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, array(), $form_id, 'campayn' );
    }

    public static function api_get_lists( $api_key )
    {
        return self::request( 'lists', 'GET', array(), $api_key );
    }

    public static function api_create_or_update_contact( $api_key, $list_id, $contact_data, $form_id = 0 )
    {
        $endpoint = "lists/{$list_id}/contacts.json";
        return self::request( $endpoint, 'POST', $contact_data, $api_key, $form_id );
    }
}