<?php if ( ! defined( 'ABSPATH' ) ) exit;

class TriggerNinja_Brevo_API
{
    const URL = 'https://api.brevo.com/v3/';
    private $api_key;
    private $form_id;

    public function __construct( $api_key = '', $form_id = 0 )
    {
        $this->api_key = $api_key;
        $this->form_id = $form_id;
    }

    public function request( $method, $endpoint, $data = array(), $options = array() )
    {
        $url = trailingslashit( self::URL ) . $endpoint;
        
        $headers = array(
            'api-key' => $this->api_key
        );
        
        return TriggerNinja_Http_Client::request( $method, $url, $data, $headers, $options, $this->form_id, 'brevo' );
    }

    /**
     * Get contact lists with pagination support
     * 
     * @param int $limit Number of lists per page
     * @param int $offset Starting offset
     * @return TriggerNinja_Response
     */
    public function get_lists( $limit = 50, $offset = 0 )
    {
        $endpoint = "contacts/lists?limit={$limit}&offset={$offset}";
        return $this->request( 'GET', $endpoint );
    }

    /**
     * Create or update a contact
     * 
     * @param array $contact_data Contact information
     * @return TriggerNinja_Response
     */
    public function create_contact( $contact_data )
    {
        return $this->request( 'POST', 'contacts', $contact_data );
    }

    /**
     * Get all lists (handles pagination internally)
     * 
     * @return array All lists
     */
    public function get_all_lists()
    {
        $all_lists = array();
        $page = 0;
        $limit = 50;
        $has_more = true;

        while( $has_more ) {
            $offset = $page * $limit;
            $response = $this->get_lists( $limit, $offset );
            
            if( $response->details && isset( $response->details->lists ) && ! empty( $response->details->lists ) ) {
                foreach( $response->details->lists as $list ) {
                    $all_lists[ $list->id ] = $list->name;
                }
                $page++;
            } else {
                $has_more = false;
            }
        }

        return $all_lists;
    }
}