<?php if ( ! defined( 'ABSPATH' ) ) exit;

final class TriggerNinja_Metabox extends NF_Abstracts_SubmissionMetabox
{
    public function __construct()
    {
        parent::__construct();

        $this->_title = __( 'TriggerNinja Integrations', 'triggerninja-for-ninja-forms' );

        // Check if any platform data exists
        if( $this->sub && ! $this->has_platform_data() ){
            remove_action( 'add_meta_boxes', array( $this, 'add_meta_boxes' ) );
        }
    }

    public function render_metabox( $post, $metabox )
    {
        $platforms = triggerninja_instance()->get_platforms();
        $has_data = false;

        foreach( $platforms as $platform_id => $platform ) {
            $platform_data = $this->sub->get_extra_value( $platform_id );
            
            if( $platform_data ) {
                $has_data = true;
                $this->render_platform_data( $platform, $platform_data );
            }
        }

        if( ! $has_data ) {
            echo '<p>' . esc_html__( 'No platform integration data available.', 'triggerninja-for-ninja-forms' ) . '</p>';
        }
    }

    /**
     * Check if any platform data exists for this submission
     * 
     * @return bool
     */
    private function has_platform_data()
    {
        $platforms = triggerninja_instance()->get_platforms();
        
        foreach( $platforms as $platform_id => $platform ) {
            if( $this->sub->get_extra_value( $platform_id ) ) {
                return true;
            }
        }
        
        return false;
    }

    /**
     * Render platform-specific data
     * 
     * @param TriggerNinja_Platform_Interface $platform
     * @param array $platform_data
     */
    private function render_platform_data( $platform, $platform_data )
    {
        $display_data = $platform->get_submission_metabox_data( $platform_data );
        
        if( empty( $display_data ) ) {
            return;
        }

        echo '<div class="triggerninja-platform-section">';
        echo '<h4>' . esc_html( $platform->get_name() ) . '</h4>';
        echo '<ul>';
        
        foreach( $display_data as $label => $value ) {
            echo '<li>';
            echo '<strong>' . esc_html( $label ) . '</strong>';
            echo '<br />' . esc_html( $value );
            echo '</li>';
        }
        
        echo '</ul>';
        echo '</div>';
        echo '<hr style="margin: 15px 0;">';
    }
}