<?php if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Interface TriggerNinja_Platform_Interface
 * 
 * Defines the contract that all marketing platform integrations must implement
 */
interface TriggerNinja_Platform_Interface
{
    /**
     * Get the platform identifier
     * 
     * @return string
     */
    public function get_id();

    /**
     * Get the platform display name
     * 
     * @return string
     */
    public function get_name();

    /**
     * Get platform settings fields configuration
     * 
     * @return array
     */
    public function get_settings_fields();

    /**
     * Get action fields configuration for forms
     * 
     * @return array
     */
    public function get_action_fields();

    /**
     * Process form submission data
     * 
     * @param array $action_settings
     * @param int $form_id
     * @param array $data
     * @return array
     */
    public function process_submission( $action_settings, $form_id, $data );

    /**
     * Get available lists/audiences from the platform
     * 
     * @return array
     */
    public function get_lists();

    /**
     * Validate platform connection/API key
     * 
     * @return bool
     */
    public function is_connected();

    /**
     * Get platform-specific metabox data for submissions
     * 
     * @param array $submission_data
     * @return array
     */
    public function get_submission_metabox_data( $submission_data );
}