<?php if ( ! defined( 'ABSPATH' ) || ! class_exists( 'NF_Abstracts_Action' )) exit;

/**
 * Abstract Platform Action Class
 * 
 * Base class that all platform-specific actions extend
 */
abstract class TriggerNinja_Platform_Action_Abstract extends NF_Abstracts_Action
{
    /**
     * Platform ID
     * 
     * @var string
     */
    protected $platform_id;

    /**
     * Platform instance
     * 
     * @var TriggerNinja_Platform_Interface
     */
    protected $platform;

    /**
     * Action timing
     * 
     * @var string
     */
    protected $_timing = 'late';

    /**
     * Action priority
     * 
     * @var string
     */
    protected $_priority = '9';

    /**
     * Constructor
     */
    public function __construct()
    {
        parent::__construct();
        
        // Get the platform instance
        $this->platform = triggerninja_instance()->get_platform( $this->platform_id );
        
        if( ! $this->platform ) {
            return; // Platform not found
        }

        // Set action properties based on platform
        $this->_name = $this->platform_id;
        $this->_nicename = $this->platform->get_name();
        
        // Setup platform-specific settings if we're in admin
        if( isset( $_GET[ 'page' ] ) && 'ninja-forms' == $_GET[ 'page' ] && current_user_can( 'manage_options' ) ) {
            // Only set up platform settings for safe admin requests:
            // - page load (no POST data), or
            // - requests that include a valid nonce to prevent CSRF
            $nonce = isset( $_REQUEST['_wpnonce'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['_wpnonce'] ) ) : '';
            if ( empty( $_POST ) || ( $nonce && wp_verify_nonce( $nonce, 'triggerninja_settings' ) ) ) {
                $this->setup_platform_settings();
            }
        }
    }

    /**
     * Setup platform-specific settings for the admin interface
     */
    protected function setup_platform_settings()
    {
        if( ! $this->platform ) return;
        
        $this->_settings = $this->platform->get_action_fields();
    }

    /**
     * Save method - intentionally left blank
     * 
     * @param array $action_settings
     */
    public function save( $action_settings )
    {
        // This section intentionally left blank.
    }

    /**
     * Process form submission
     * 
     * @param array $action_settings
     * @param int $form_id
     * @param array $data
     * @return array
     */
    public function process( $action_settings, $form_id, $data )
    {
        if( ! $this->platform ) {
            $data[ 'debug' ][ $this->platform_id ] = __( 'Platform not found', 'triggerninja-for-ninja-forms' );
            return $data;
        }

        return $this->platform->process_submission( $action_settings, $form_id, $data );
    }

    /**
     * Get the platform ID (must be implemented by child classes)
     * 
     * @return string
     */
    abstract protected function get_platform_id();
}