(function ($) {
    $(document).ready(function () {
        var checkConfig = function (isInitialCheck) {
            // Show checking indicator if config already exists
            if (!isInitialCheck && $('#translatejs-config-display').length) {
                $('#translatejs-config-display').hide();
                $('#translatejs-config-error').hide();
                $('#translatejs-checking').show();
            }

            $.post(ajaxurl, {
                action: 'translatejs_check_config'
            }, function (response) {
                if (response.success) {
                    // Config updated successfully
                    if ($('#translatejs-waiting').length) {
                        // First time setup - show success message
                        $('#translatejs-waiting').hide();
                        $('#translatejs-success').fadeIn();
                    }
                } else {
                    console.log('Translate.js Config Check:', response);
                    // Check if there's an error message from the API
                    var errorMessage = response.data || 'Unknown error';

                    if ($('#translatejs-waiting').length) {
                        // During initial setup - keep polling for connection errors
                        setTimeout(function () {
                            checkConfig(false);
                        }, 5000);
                    } else if ($('#translatejs-checking').length) {
                        // Hide checking indicator and show error instead of config
                        $('#translatejs-checking').hide();
                        $('#translatejs-config-display').hide();
                        $('#translatejs-config-error').html('<strong>Error:</strong> ' + errorMessage).show();
                    }
                }
            }).fail(function () {
                // Network error
                if ($('#translatejs-waiting').length) {
                    setTimeout(function () {
                        checkConfig(false);
                    }, 5000);
                } else if ($('#translatejs-checking').length) {
                    $('#translatejs-checking').hide();
                    $('#translatejs-config-error').html('<strong>Network Error:</strong> Unable to connect to Translate.js').show();
                }
            });
        };

        // Check actual config from the server on page load
        // Only run if we are on the settings page and have an API key saved (which implies the script block was originally outputting this)
        // In the PHP code we wrapped this in if ($is_api_key_saved). 
        // We can check for a specific element that exists only when key is saved, or just let it fail gracefully/check presence of specific IDs.
        // The original code passed `ajaxurl` which is global in admin.
        
        if ($('#translatejs-waiting').length || $('#translatejs-config-display').length) {
             setTimeout(function () {
                checkConfig(true);
            }, 500);
        }
       
    });
})(jQuery);
