<?php
/*
 * Plugin Name: TouchTry Watch Try-On
 * Description: Try watches in AR on WooCommerce product pages.
 * Version: 1.0.5
 * Author: TouchTry
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: touchtry-watch-try-on
 * Domain Path: /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// ===========================
//  ADMIN MENU PAGES
// ===========================
function ttwt_add_admin_pages() {
	add_menu_page(
		esc_html__( 'TouchTry Watch Try-On', 'touchtry-watch-try-on' ),
		esc_html__( 'TouchTry Watch Try-On', 'touchtry-watch-try-on' ),
		'manage_options',
		'ttwt_dashboard',
		'ttwt_dashboard_page',
		'dashicons-visibility',
		56
	);

	add_submenu_page(
		'ttwt_dashboard',
		esc_html__( 'Pricing', 'touchtry-watch-try-on' ),
		esc_html__( 'Pricing', 'touchtry-watch-try-on' ),
		'manage_options',
		'ttwt_pricing',
		'ttwt_pricing_page'
	);

	add_submenu_page(
		'ttwt_dashboard',
		esc_html__( 'Contact', 'touchtry-watch-try-on' ),
		esc_html__( 'Contact', 'touchtry-watch-try-on' ),
		'manage_options',
		'ttwt_contact',
		'ttwt_contact_page'
	);
}
add_action( 'admin_menu', 'ttwt_add_admin_pages' );

// ===========================
//  LOAD ADMIN CSS
// ===========================
function ttwt_admin_assets( $hook ) {
	if (
		$hook !== 'toplevel_page_ttwt_dashboard' &&
		$hook !== 'touchtry-watch-try-on_page_ttwt_pricing' &&
		$hook !== 'touchtry-watch-try-on_page_ttwt_contact'
	) {
		return;
	}

	wp_enqueue_style(
		'ttwt-style',
		esc_url( plugin_dir_url( __FILE__ ) . 'assets/style.css' )
	);
}
add_action( 'admin_enqueue_scripts', 'ttwt_admin_assets' );

// ===========================
//  ADMIN PAGES CONTENT
// ===========================
function ttwt_dashboard_page() {
	$accepted = get_option( 'ttwt_privacy_accepted' );

	if ( ! $accepted ) {
		echo '<div id="ttwt-privacy-popup" style="position:fixed;top:0;left:0;width:100%;height:100%;background:#000a;z-index:9999;display:flex;align-items:center;justify-content:center;">
			<div style="background:#fff;padding:30px;border-radius:12px;width:90%;max-width:500px;box-shadow:0 0 20px rgba(0,0,0,0.2);text-align:center;">
				<h2>' . esc_html__( 'Privacy Policy', 'touchtry-watch-try-on' ) . '</h2>
				<p style="font-size:14px;color:#333;margin-bottom:20px;">' . esc_html__( 'By using TouchTry Watch Try-On, you agree to our privacy policy. We may collect limited usage data to improve AR experience.', 'touchtry-watch-try-on' ) . '</p>
				<form method="post" action="' . esc_url( admin_url( 'admin-post.php' ) ) . '">
					<input type="hidden" name="action" value="ttwt_accept_privacy">
					<button type="submit" style="padding:10px 20px;background:#111;color:#fff;border:none;border-radius:6px;cursor:pointer;">' . esc_html__( 'Agree & Continue', 'touchtry-watch-try-on' ) . '</button>
				</form>
			</div>
		</div>';
	} else {
		include plugin_dir_path( __FILE__ ) . 'admin/dashboard.php';
	}
}

function ttwt_pricing_page() {
	include plugin_dir_path( __FILE__ ) . 'admin/pricing.php';
}

function ttwt_contact_page() {
	include plugin_dir_path( __FILE__ ) . 'admin/contact.php';
}

// ===========================
//  HANDLE PRIVACY AGREEMENT
// ===========================
add_action( 'admin_post_ttwt_accept_privacy', 'ttwt_handle_privacy_accept' );
function ttwt_handle_privacy_accept() {
	if ( current_user_can( 'manage_options' ) ) {
		update_option( 'ttwt_privacy_accepted', true );
	}
	wp_safe_redirect( esc_url( admin_url( 'admin.php?page=ttwt_dashboard' ) ) );
	exit;
}

// ===========================
//  ADD CUSTOM FIELD TO PRODUCT
// ===========================
add_action( 'woocommerce_product_options_general_product_data', function () {
	woocommerce_wp_text_input(
		array(
			'id'          => '_watch_ar_link',
			'label'       => esc_html__( 'Watch AR Try-On Link', 'touchtry-watch-try-on' ),
			'placeholder' => esc_url( 'https://yourdomain.com/ar/watch-tryon/?id=123' ),
			'desc_tip'    => true,
			'description' => esc_html__( 'Paste the link to the watch AR try-on experience.', 'touchtry-watch-try-on' ),
		)
	);
} );

add_action( 'woocommerce_process_product_meta', function ( $post_id ) {
	if ( isset( $_POST['_watch_ar_link'] ) ) {
		update_post_meta(
			$post_id,
			'_watch_ar_link',
			esc_url_raw( wp_unslash( $_POST['_watch_ar_link'] ) )
		);
	}
} );

// ===========================
//  DISPLAY BUTTON ON PRODUCT PAGE
// ===========================
add_action( 'woocommerce_after_add_to_cart_button', function () {
	global $product;
	$ar_link = get_post_meta( $product->get_id(), '_watch_ar_link', true );

	if ( $ar_link ) {
		echo '<a class="ttwt-tryon-button" href="' . esc_url( $ar_link ) . '" target="_blank">' . esc_html__( 'Try On', 'touchtry-watch-try-on' ) . '</a>';
	}
} );

// ===========================
//  FRONTEND CSS
// ===========================
add_action( 'wp_enqueue_scripts', function () {
	wp_enqueue_style(
		'ttwt-frontend-style',
		esc_url( plugin_dir_url( __FILE__ ) . 'assets/frontend.css' )
	);
} );
