<?php
/**
 * Admin Pricing Page
 *
 * @package TouchTry_Watch_Try_On
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<div class="ttwt-container">
	<h1><?php echo esc_html__( 'Pricing Plans', 'touchtry-watch-try-on' ); ?></h1>
	<p><?php echo esc_html__( 'Upgrade anytime as your business grows. All plans include AR Try-On features.', 'touchtry-watch-try-on' ); ?></p>

	<div class="ttwt-pricing-cards">

		<!-- STARTER -->
		<div class="plan">
			<h3><?php echo esc_html__( 'STARTER', 'touchtry-watch-try-on' ); ?></h3>
			<p class="plan-desc"><?php echo esc_html__( 'Best for new AR launches & small stores', 'touchtry-watch-try-on' ); ?></p>

			<p class="plan-price">
				<?php echo esc_html__( '$399 / month', 'touchtry-watch-try-on' ); ?>
			</p>

			<ul>
				<li><?php echo esc_html__( 'All AR categories included (Jewelry, Furniture, Clothes, Watches, Eyewear, Shoes / Home Appliances)', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Up to 300 AR SKUs', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Up to 20,000 AR views/month', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Web embed (Shopify / WooCommerce / Custom)', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Basic analytics dashboard', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Standard email support', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Core onboarding guide', 'touchtry-watch-try-on' ); ?></li>
			</ul>

			<button onclick="window.location.href='<?php echo esc_url( 'https://touchtry.com/pricing/' ); ?>';">
				<?php echo esc_html__( 'Buy Now', 'touchtry-watch-try-on' ); ?>
			</button>
		</div>

		<!-- BASIC -->
		<div class="plan">
			<h3><?php echo esc_html__( 'BASIC', 'touchtry-watch-try-on' ); ?></h3>
			<p class="plan-desc"><?php echo esc_html__( 'For growing D2C brands (more SKUs + more traffic + better support)', 'touchtry-watch-try-on' ); ?></p>

			<p class="plan-price">
				<?php echo esc_html__( '$649 / month', 'touchtry-watch-try-on' ); ?>
			</p>

			<ul>
				<li><?php echo esc_html__( 'Everything in Starter, plus:', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Up to 700 AR SKUs', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Up to 75,000 AR views/month', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Enhanced analytics + engagement reports', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Priority support (faster response)', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Storefront styling assistance (button placement + UI suggestions)', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Basic integrations support (Pixel/GA setup guidance)', 'touchtry-watch-try-on' ); ?></li>
			</ul>

			<button onclick="window.location.href='<?php echo esc_url( 'https://touchtry.com/pricing/' ); ?>';">
				<?php echo esc_html__( 'Buy Now', 'touchtry-watch-try-on' ); ?>
			</button>
		</div>

		<!-- ADVANCED -->
		<div class="plan">
			<h3><?php echo esc_html__( 'ADVANCED', 'touchtry-watch-try-on' ); ?></h3>
			<p class="plan-desc"><?php echo esc_html__( 'For brands scaling globally (multi-store + tracking + premium support)', 'touchtry-watch-try-on' ); ?></p>

			<p class="plan-price">
				<?php echo esc_html__( '$1,299 / month', 'touchtry-watch-try-on' ); ?>
			</p>

			<ul>
				<li><?php echo esc_html__( 'Everything in Basic, plus:', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Up to 1,500 AR SKUs', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Up to 200,000 AR views/month', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Phone + Chat support', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Multi-store / multi-domain support', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Advanced event tracking (GA / Meta Pixel / custom events)', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Performance optimization support (faster load for high traffic pages)', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Dedicated onboarding session (implementation review)', 'touchtry-watch-try-on' ); ?></li>
			</ul>

			<button onclick="window.location.href='<?php echo esc_url( 'https://touchtry.com/pricing/' ); ?>';">
				<?php echo esc_html__( 'Buy Now', 'touchtry-watch-try-on' ); ?>
			</button>
		</div>

		<!-- ENTERPRISE -->
		<div class="plan">
			<h3><?php echo esc_html__( 'ENTERPRISE', 'touchtry-watch-try-on' ); ?></h3>
			<p class="plan-desc"><?php echo esc_html__( 'High-traffic AR commerce with dedicated success + SLA', 'touchtry-watch-try-on' ); ?></p>

			<p class="plan-price">
				<?php echo esc_html__( 'Contact Us', 'touchtry-watch-try-on' ); ?>
			</p>

			<ul>
				<li><?php echo esc_html__( 'Everything in Advanced, plus:', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( '8,000+ AR SKUs', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( '1M+ monthly views (or more)', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Custom integrations (PIM/ERP/CDN/Headless)', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Dedicated Success Manager', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'SLA + 24×7 support option', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Custom rollout plan (phased SKU enablement + training)', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Security & compliance support (as required)', 'touchtry-watch-try-on' ); ?></li>
			</ul>

			<button onclick="window.location.href='<?php echo esc_url( 'https://touchtry.com/#my-contact' ); ?>';">
				<?php echo esc_html__( 'Contact', 'touchtry-watch-try-on' ); ?>
			</button>
		</div>

	</div>
</div>