<?php
/**
 * Admin Dashboard Page
 *
 * @package TouchTry_Watch_Try_On
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$video_id = 'jqC-6LrMTOE';
?>

<div class="ttwt-container">
	<h1><?php echo esc_html__( 'Welcome to TouchTry Watch Try-On', 'touchtry-watch-try-on' ); ?></h1>
	<p><?php echo esc_html__( 'Upload your AR models and link them to your WordPress products easily with real-time preview and analytics.', 'touchtry-watch-try-on' ); ?></p>

	<div style="display: flex; gap: 40px; align-items: flex-start; margin-top: 20px; flex-wrap: wrap;">
		
		<iframe
			width="560"
			height="315"
			src="<?php echo esc_url( 'https://www.youtube.com/embed/' . rawurlencode( $video_id ) . '?rel=0' ); ?>"
			title="<?php echo esc_attr__( 'TouchTry Watch Try-On Overview', 'touchtry-watch-try-on' ); ?>"
			allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
			allowfullscreen>
		</iframe>

		<div class="ttwt-feature-list">
			<h2><?php echo esc_html__( 'What You Can Do', 'touchtry-watch-try-on' ); ?></h2>
			<ul>
				<li><?php echo esc_html__( 'Upload your .glb watch model files securely', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Link watch models to specific WooCommerce products', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'View real-time analytics on AR try-ons', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Customize branding and try-on CTA buttons', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Generate unique QR codes for product previews', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Track monthly try-on session stats', 'touchtry-watch-try-on' ); ?></li>
				<li><?php echo esc_html__( 'Preview live AR on mobile or desktop instantly', 'touchtry-watch-try-on' ); ?></li>
			</ul>
			<br>

			<a 
				href="<?php echo esc_url( 'https://touchtry.com/WatchAR/auth.php?mode=signup' ); ?>" 
				class="ttwt-button-dark"
			>
				<?php echo esc_html__( 'Go To Dashboard', 'touchtry-watch-try-on' ); ?>
			</a>
		</div>

	</div>
</div>