<?php
/**
 * Admin Contact Page
 *
 * @package TouchTry_Watch_Try_On
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<div class="ttwt-container">
	<h1><?php echo esc_html__( 'Need Help?', 'touchtry-watch-try-on' ); ?></h1>

	<div class="ttwt-contact-box">
		<img 
			src="<?php echo esc_url( plugin_dir_url( __FILE__ ) . '../assets/contact.png' ); ?>" 
			alt="<?php echo esc_attr__( 'Support', 'touchtry-watch-try-on' ); ?>" 
			width="300"
		>

		<div>
			<p><strong><?php echo esc_html__( 'Email:', 'touchtry-watch-try-on' ); ?></strong> 
				<a href="mailto:mail@touchtry.com"><?php echo esc_html( 'mail@touchtry.com' ); ?></a>
			</p>
			<p><strong><?php echo esc_html__( 'Call Us:', 'touchtry-watch-try-on' ); ?></strong> 
				<?php echo esc_html( '+91 9636014166' ); ?>
			</p>
			<p><strong><?php echo esc_html__( 'Website:', 'touchtry-watch-try-on' ); ?></strong> 
				<a href="<?php echo esc_url( 'https://touchtry.com' ); ?>" target="_blank" style="color:#6366f1; text-decoration:underline;">
					<?php echo esc_html( 'touchtry.com' ); ?>
				</a>
			</p>
		</div>
	</div>
</div>
