<?php
/**
 * Totej Settings Page
 *
 * @package           Mnording
 * @author            Mattias Nording
 * @copyright         2019 Totej Media
 * @license           GPL-2.0-or-later
 */
class TotejSettingsPage {

	/**
	 * Add the top level menu page.
	 */
	public function totej_media_options_page() {
		if ( ! menu_page_url( 'totej-media-settings', false ) ) {
			register_setting( 'totej-media-settings', 'totej-media-settings' );
			add_menu_page(
				'Totej Media',
				'Totej Media Settings',
				'manage_options',
				'totej-media-settings',
				array( $this, 'totej_media_options_page_html' ),
				plugins_url( 'totej-vat-display-selector/images/icon.svg' )
			);
		}

	}
	public function __construct() {

		add_action( 'admin_menu', array( $this, 'totej_media_options_page' ) );

	}
	function totej_media_options_page_html() {
		// check user capabilities
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		// add error/update messages

		// check if the user have submitted the settings
		// WordPress will add the "settings-updated" $_GET parameter to the url
		if ( isset( $_GET['settings-updated'] ) ) {
			// add settings saved message with the class of "updated"
			add_settings_error( 'totej-media-settings', 'totej-error', __( 'Settings Saved', 'totej-media' ), 'updated' );
		}

		// show error/update messages
		settings_errors( 'totej-media-settings' );
		?>
	<div class="wrap">
		<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
		<form action="options.php" method="post">
			<?php
			// output security fields for the registered setting "wporg"
			settings_fields( 'totej-media-settings' );

			// output setting sections and their fields
			// (sections are registered for "wporg", each field is registered to a specific section)
			do_settings_sections( 'totej-media-settings' );
			// output save settings button
			submit_button( 'Save Settings' );
			?>
		</form>
	</div>
		<?php
	}


}
