<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
class TotejVatDisplaySettings {
	private $settings_helper;
	/**
	 * @internal never define functions inside callbacks.
	 * these functions could be run multiple times; this would result in a fatal error.
	 */

	/**
	 * custom option and settings
	 */
	function totej_media_vat_display_settings_init() {
		// Register a new setting for "wporg" page.
		register_setting( 'totej-media-settings', 'totej-media-settings' );
		// Register a new section in the "wporg" page.
		add_settings_section(
			'totej_media_vat_display_section',
			__( 'Totej Media Settings', 'totej-vat-display' ),
			array( $this, 'wporg_section_developers_callback' ),
			'totej-media-settings'
		);

		// Register a new field in the "wporg_section_developers" section, inside the "wporg" page.
		// Register a new field in the "wporg_section_developers" section, inside the "wporg" page.
		add_settings_field(
			'vat-display-default', // As of WP 4.6 this value is used only internally.
			// Use $args' label_for to populate the id inside the callback.
			__( 'Default price setting', 'totej-vat-display' ),
			array( $this, 'wporg_field_pill_cb' ),
			'totej-media-settings',
			'totej_media_vat_display_section',
			array(
				'label_for'         => 'vat-display-default',
				'class'             => 'wporg_row',
				'wporg_custom_data' => 'custom',
			)
		);

		add_settings_field(
			'exvat-button-text', // As of WP 4.6 this value is used only internally.
			// Use $args' label_for to populate the id inside the callback.
			__( 'Button text for excluding vat', 'totej-vat-display' ),
			array( $this, 'totej_text_input_field' ),
			'totej-media-settings',
			'totej_media_vat_display_section',
			array(
				'label_for'         => 'exvat-button-text',
				'class'             => 'wporg_row',
				'wporg_custom_data' => 'custom',
			)
		);
		add_settings_field(
			'incvat-button-text', // As of WP 4.6 this value is used only internally.
			// Use $args' label_for to populate the id inside the callback.
			__( 'Button text for including vat', 'totej-vat-display' ),
			array( $this->settings_helper, 'totej_text_input_field' ),
			'totej-media-settings',
			'totej_media_vat_display_section',
			array(
				'label_for'         => 'incvat-button-text',
				'class'             => 'wporg_row',
				'wporg_custom_data' => 'custom',
			)
		);
	}
	public function __construct() {
		if ( ! class_exists( 'TotejSettingsPage' ) ) {
			require 'includes/class-totejsettingspage.php';
				new TotejSettingsPage();
		}
		if ( ! class_exists( 'SettingFieldsHelper' ) ) {
			require 'helpers/class-settingfieldshelper.php';

		}
		$this->settings_helper = new SettingFieldsHelper();
		add_action( 'admin_menu', array( $this, 'totej_media_vat_display_settings_init' ) );
	}


	/**
	 * Developers section callback function.
	 *
	 * @param array $args  The settings array, defining title, id, callback.
	 */
	function wporg_section_developers_callback( $args ) {
		?>
	<h2>Totej Media VAT Display Settings</h2>
		<?php
	}
	public function totej_text_input_field( $args ) {
		$options = get_option( 'totej-media-settings' );
		?>
		<input name="totej-media-settings[<?php echo esc_attr( $args['label_for'] ); ?>]" type="text" value="<?php echo esc_attr( $options[ $args['label_for'] ] ) ?? ''; ?>" />
		<?php
	}
	/**
	 * Pill field callbakc function.
	 *
	 * WordPress has magic interaction with the following keys: label_for, class.
	 * - the "label_for" key value is used for the "for" attribute of the <label>.
	 * - the "class" key value is used for the "class" attribute of the <tr> containing the field.
	 * Note: you can add custom key value pairs to be used inside your callbacks.
	 *
	 * @param array $args
	 */
	function wporg_field_pill_cb( $args ) {
		// Get the value of the setting we've registered with register_setting()
		$options = get_option( 'totej-media-settings' );
		?>
	<select
			id="<?php echo esc_attr( $args['label_for'] ); ?>"
			name="totej-media-settings[<?php echo esc_attr( $args['label_for'] ); ?>]">
		<option value="red" <?php echo isset( $options[ $args['label_for'] ] ) ? ( selected( $options[ $args['label_for'] ], 'exvat', false ) ) : ( '' ); ?>>
			<?php esc_html_e( 'Exclusive VAT', 'totej-vat-display' ); ?>
		</option>
		 <option value="blue" <?php echo isset( $options[ $args['label_for'] ] ) ? ( selected( $options[ $args['label_for'] ], 'incvat', false ) ) : ( '' ); ?>>
			<?php esc_html_e( 'Inclusive VAT', 'totej-vat-display' ); ?>
		</option>
	</select>
	<p class="description">
		<?php esc_html_e( 'You take the blue pill and the story ends. You wake in your bed and you believe whatever you want to believe.', 'totej-vat-display' ); ?>
	</p>
	<p class="description">
		<?php esc_html_e( 'You take the red pill and you stay in Wonderland and I show you how deep the rabbit-hole goes.', 'totej-vat-display' ); ?>
	</p>
		<?php
	}




	/**
	 * Top level menu callback function
	 */

}
