<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
/**
 * Totej VAT Display Selector
 *
 * @package           WooCommerce VAT Display
 * @author            Totej Media
 * @copyright         2023 Totej Media
 * @license           GPL-2.0-or-later
 *
 * @wordpress-plugin
 * Plugin Name:       Totej VAT Display Selector
 * Plugin URI:        https://totejmedia.se/woocommerce-moms-valjare/
 * Description:       Allow you customers to view your prices excl or incl VAT.
 * Version:           1.0.2
 * Requires at least: 5.2
 * Requires PHP:      7.2
 * WC tested up to:   6.5.1
 * Requires Plugins:  woocommerce
 * Author:            totejmedia
 * Author URI:        https://totejmedia.se
 * License:           GPL
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 */

class TotejVatDisplayPlugin {
	private function price_setting_on_user() {
		if ( isset( $_COOKIE['totej_vat_display_setting'] ) ) {
			return sanitize_text_field( wp_unslash( $_COOKIE['totej_vat_display_setting'] ) );
		}
		return get_option( 'totej_vat_display_default' );
	}
	function edit_price_display( $price, $that ) {

		$price_incl_tax = wc_get_price_including_tax( $that );
		 $price_ex_tax  = wc_get_price_excluding_tax( $that );
		if ( 'exvat' === $this->price_setting_on_user() ) {
			return wc_price( $price_ex_tax ) . ' <small class="woocommerce-price-suffix">' . __( 'Ex Vat', 'totej-vat-display' ) . '</small>';
		} else {
			   return wc_price( $price_incl_tax ) . ' <small class="woocommerce-price-suffix">' . __( 'Incl Vat', 'totej-vat-display' ) . '</small>';

		}

	}

	public function totej_vat_display_selector_shortcode_callback( $atts ) {
		$options = get_option( 'totej-media-settings' );

		$incvaturl = wp_nonce_url( '?totej-vat-selector=incvat', 'change-vat-display', 'totej-vat-nonce' );
		$exvaturl  = wp_nonce_url( '?totej-vat-selector=exvat', 'change-vat-display', 'totej-vat-nonce' );
		ob_start();
		?>
		<div class="totej-vat-selector">
			<a class="button totej-vat-selector-button totej-vat-selector-inc-vat-button <?php echo ( 'incvat' === $this->price_setting_on_user() ) ? '' : 'disabled'; ?>" style="margin-right:0" href="<?php echo esc_url( $incvaturl ); ?>"><?php echo esc_html( $options['incvat-button-text'] ); ?></a>
			<a class="button totej-vat-selector-button totej-vat-selector-ex-vat-button <?php echo ( 'exvat' === $this->price_setting_on_user() ) ? '' : 'disabled'; ?>" style="margin-left:0" href="<?php echo esc_url( $exvaturl ); ?>"><?php echo esc_html( $options['exvat-button-text'] ); ?></a>
		</div>
		<?php
		$out1 = ob_get_contents();
		ob_end_clean();

		return $out1;
	}
	public function __construct() {

		add_action( 'template_redirect', array( $this, 'check_redirect' ) );
		add_action( 'plugins_loaded', array( $this, 'init' ) );

	}
	public function totej_vat_display_cart_item_callback( $price, $prod ) {

		if ( 'exvat' === $this->price_setting_on_user() ) {
			return wc_get_price_excluding_tax( $prod );
		} else {
			return wc_get_price_including_tax( $prod );
		}
	}
	public function check_redirect() {

		if ( isset( $_GET['totej-vat-selector'] ) && isset( $_GET['totej-vat-nonce'] ) && isset( $_SERVER['REQUEST_URI'] ) ) {

			if ( wp_verify_nonce( wp_unslash( sanitize_key( $_GET['totej-vat-nonce'] ) ), 'change-vat-display' ) ) {
				setcookie( 'totej_vat_display_setting', wp_unslash( sanitize_key( $_GET['totej-vat-selector'] ) ), time() + 3600 * 24, '/' );  /* expire in 1 hour */
				$url = strtok( esc_url_raw( wp_unslash( $_SERVER['REQUEST_URI'] ) ), '?' );
				wp_safe_redirect( $url );
				exit;

			}
		}
	}
	public function init() {
		add_shortcode( 'totej_vat_display_selector', array( $this, 'totej_vat_display_selector_shortcode_callback' ) );
		add_filter( 'woocommerce_get_price_html', array( $this, 'edit_price_display' ), 10, 2 );

		add_filter( 'woocommerce_cart_product_price', array( $this, 'totej_vat_display_cart_item_callback' ), 10, 2 );

		require 'class-totejvatdisplaysettings.php';
		new TotejVatDisplaySettings();
	}

}


new TotejVatDisplayPlugin();
