/**
 * Admin JavaScript for Totals Report for WooCommerce
 */
(function($) {
    'use strict';

    /**
     * Initialize the admin functionality
     */
    function init() {
        // Handle pagination links to retain the per_page parameter
        $('.tablenav-pages a').on('click', function(e) {
            const perPage = $('#per-page').val();
            const href = $(this).attr('href');
            
            if (perPage && href.indexOf('per_page=') === -1) {
                e.preventDefault();
                window.location.href = href + '&per_page=' + perPage;
            }
        });
    }

    // Initialize when document is ready
    $(document).ready(init);

})(jQuery);