# Totals Report for WooCommerce

![Plugin Version](https://img.shields.io/badge/version-1.0.2-blue.svg)
![WordPress Compatibility](https://img.shields.io/badge/wordpress-5.0+-green.svg)
![WooCommerce Compatibility](https://img.shields.io/badge/woocommerce-5.0.0+-purple.svg)
![PHP Version](https://img.shields.io/badge/php-7.2+-orange.svg)

## Overview

Totals Report for WooCommerce is a powerful and lightweight WordPress plugin designed to provide comprehensive insights into your WooCommerce product catalog. With a single click, store managers can access detailed inventory statistics, helping them make informed decisions about stock management.

## 🌟 Key Features

- **Comprehensive Product Insights**
  - Total product count
  - In-stock and out-of-stock product tracking
  - Low stock and backorder monitoring
  - Detailed variation analysis
  - Stock quantity overview

- **Category-Specific Analytics**
  - Products per category
  - In-stock products per category
  - Out-of-stock products per category
  - Low stock products per category
  - On backorder products per category
  - Variable products per category

- **Performance Optimized**
  - Efficient database querying
  - Caching mechanisms
  - Pagination for large catalogs
  - Customizable rows per page

- **Compatibility**
  - WordPress 5.0+
  - WooCommerce 5.0.0+
  - High-Performance Order Storage (HPOS) support
  - Multisite ready

- **Developer Friendly**
  - Translation ready
  - Clean, well-documented code
  - Easily extendable

## 🚀 Installation

### Automatic Installation

1. Go to WordPress admin panel
2. Navigate to Plugins > Add New
3. Search for "Totals Report for WooCommerce"
4. Click "Install Now" and then "Activate"

### Manual Installation

1. Download the plugin ZIP file
2. Go to WordPress admin panel
3. Navigate to Plugins > Add New
4. Click "Upload Plugin"
5. Choose the downloaded ZIP and click "Install Now"
6. Activate the plugin

## 📊 Usage

After activation, you'll find a new menu item under WooCommerce:

**WooCommerce > Totals Report**

The report page displays:
- Total number of products
- In-stock products
- Out-of-stock products
- Low stock products
- On backorder products
- Total variations
- Stock quantity
- Product type breakdown
- Detailed category analysis with:
  - Total products per category
  - In-stock products per category
  - Out-of-stock products per category
  - Low stock products per category
  - On backorder products per category
  - Variable products per category

## 📥 Export Options

The plugin allows you to export reports in multiple formats:
- CSV
- JSON
- XML

These exports include all product data and category breakdowns, making it easy to use the data for further analysis or reporting.

## 🔧 Requirements

- WordPress 5.0+
- PHP 7.2+
- WooCommerce 5.0.0+

## 💡 Support

Need help? Check our [support page](https://bigdrop.gr/contact-us/) or open an issue on GitHub.

## 📝 Changelog

### 1.0.2
- Changed terminology from "Available" to "In Stock" to match WooCommerce standards
- Added Low Stock and On Backorder tracking for products
- Added pagination to the Category Reports for easier navigation
- Added "rows per page" option to customize the number of categories displayed
- Redesigned the report interface to be wider and left-aligned
- Moved export buttons to the bottom of the page
- Added new columns to category report:
  - Low Stock Products - Shows products with low stock levels in each category
  - On Backorder Products - Shows backorder products in each category
- Enhanced export functionality to include the new data

### 1.0.1
- Fixed display of category names in reports (previously showing slugs)
- Added new columns to the Product Categories report:
  - Available Products - Shows the number of in-stock products for each category
  - Out of Stock Products - Shows the number of out-of-stock products for each category
  - Variable Products - Shows the number of variable products for each category
- Improved export functionality to include the new category data

### 1.0.0
- Initial public release

## 📜 License

This project is licensed under the GPL-2.0-or-later License.

## 🏆 Credits

Developed with ❤️ by [BigDrop.gr](https://bigdrop.gr)