jQuery(document).ready(function($){
    // Cache preview elements
    var $label = $('#total-views-live-preview .total-views-label');
    var $count = $('#total-views-live-preview .total-views-count');

    // Live preview for label
    $('input[name="total_views_label"]').on('input', function(){
        $label.text($(this).val() + ':');
    });

    // Live preview for style options
    $('input[name="total_views_bold"], input[name="total_views_italic"], input[name="total_views_underline"], input[name="total_views_color"]').on('input change', function(){
        var color = $('input[name="total_views_color"]').val();
        var bold = $('input[name="total_views_bold"]').is(':checked') ? 'bold' : 'normal';
        var italic = $('input[name="total_views_italic"]').is(':checked') ? 'italic' : 'normal';
        var underline = $('input[name="total_views_underline"]').is(':checked') ? 'underline' : 'none';

        $label.css({
            'color': color,
            'font-weight': bold,
            'font-style': italic,
            'text-decoration': underline
        });
        $count.css({
            'color': color,
            'font-weight': bold,
            'font-style': italic,
            'text-decoration': underline
        });
    });


});
