<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://github.com/k0d3d
 * @since             1.0.0
 * @package           Tohju_Bot
 *
 * @wordpress-plugin
 * Plugin Name:       Tohju AI - Shopping Assistant and Recommendations 
 * Plugin URI:        https://tohju.com/posts/woocommerce-ai-chatbot/
 * Description:       Tohju helps users create AI Agents and AI Product and Post recommendations easily. Connect your Woocommerce Store to Tohju and create store managers and shop assistants instantly. 
 * Version:           1.1.07
 * Author:            Tohju Dev
 * Author URI:        https://github.com/k0d3d/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       tohju-ai-shopping-assistant
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'TOHJU_BOT_VERSION', '1.1.07' );


require_once plugin_dir_path(__FILE__) . 'includes/tohju-bot-functions.php';
require_once plugin_dir_path(__FILE__) . 'includes/class-tohju-bot-db.php';


/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-tohju-bot-activator.php
 */
function tohju_bot_activate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-tohju-bot-activator.php';
	Tohju_Bot_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-tohju-bot-deactivator.php
 */
function tohju_bot_deactivate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-tohju-bot-deactivator.php';
	Tohju_Bot_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'tohju_bot_activate' );
register_deactivation_hook( __FILE__, 'tohju_bot_deactivate' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-tohju-bot.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function tohju_bot_run() {

	$plugin = new Tohju_Bot();
	$plugin->run();

}
tohju_bot_run();
