(function( $ ) {
	'use strict';

	/**
	 * All of the code for your public-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */


	

})( jQuery );

jQuery(document).ready(function($) {
	const url = tohjuData.url;
	const iframeWrapper = $('#tohju-bot-custom-iframe-wrapper');
	const iframe = $('#tohju-bot-custom-iframe');
	const floatingIcon = $('#tohju-bot-custom-floating-icon');
	const fullscreenButton = $('#tohju-bot-custom-fullscreen');
	const openTabButton = $('#tohju-bot-custom-open-tab');
	const minimizeButton = $('#tohju-bot-custom-minimize');

	floatingIcon.on('click', function() {
			iframe.attr('src', url);
			iframeWrapper.removeClass('tohju-d-none');
			floatingIcon.addClass('tohju-d-none');
	});

	minimizeButton.on('click', function() {
			iframeWrapper.addClass('tohju-d-none');
			floatingIcon.removeClass('tohju-d-none');
	});

	fullscreenButton.on('click', function() {
			iframe.css({ width: '100%', height: '100vh' });
	});

	openTabButton.on('click', function() {
			window.open(url, '_blank');
	});
});
