<?php
class Tohju_Bot_Widgets
{

  public function replace_content($content)
  {
    $content .= $this->display_recommended_posts();

    return $content;
  }

  private function request_recommendation($item)
  {

    $body = [];

    $namespace = tohju_bot_get_namespace($item->post_type) ;

    $body['inputs'] = "$item->post_title\n$item->post_excerpt";
    $body['filter'] = [
      "wp_domain" =>  $_SERVER['HTTP_HOST']//get origin domain
    ];

    $json_body = json_encode($body);

    $data = array(
      'body' => $json_body,
      'headers' => array(
        'Content-Type' => 'application/json',  // Set content type to JSON
      ),
    );

    $namespace = tohju_bot_get_namespace($item->post_type);

    // Send POST request
    $response = wp_remote_post(TOHJU_BOT_CF_WORKER_URL . "/api/cms/namespaces/$namespace/query?topK=20&returnValues=false&returnMetadata=true", $data);

    // Check for errors
    if (is_wp_error($response)) {
      $error_message = $response->get_error_message();
      return [];
    } else {
      $status_code = wp_remote_retrieve_response_code($response);
      $response_body = wp_remote_retrieve_body($response);
      if ($status_code !== 200) {
        return [];
      }

      // You can now use $body as needed, for example:
      $data = json_decode($response_body, true);
      // return [];
      return $data['matches'];
    }
  }

  private function tohju_bot_get_recommended_posts()
  {
    global $wp;
    $current_domain = $_SERVER['HTTP_HOST'];
    $current_post = get_post();
    $recommendation_response = $this->request_recommendation($current_post);

    $recommended_posts = array();
    foreach ($recommendation_response as $match) {
      if ($match['metadata']['wp_domain'] == $current_domain && $match['metadata']['post_type'] == 'post') {
        $recommended_posts[] = get_post($match['metadata']['post_ID']);
      }
    }

    return $recommended_posts;
  }

  private function tohju_bot_get_recommended_products()
  {
    // $current_product = wc_get_product(get_the_ID());
    $current_product = get_post();
    $recommendation_response = $this->request_recommendation($current_product);

    $recommended_products = array();
    foreach ($recommendation_response as $match) {
      if ($match['metadata']['wp_domain'] == $_SERVER['HTTP_HOST'] && $match['metadata']['post_type'] == 'product') {
        $recommended_products[] = wc_get_product($match['metadata']['post_ID']);
      }
    }

    return $recommended_products;
  }
  /**
   * Display recommended products on shop pages
   */
  public function display_recommended_products()
  {
    if (get_option('tohju_bot_display_recommended_products')) {
      // Get the list of recommended products
      $recommended_products = array_slice($this->tohju_bot_get_recommended_products(), 0, 4);

      if (!empty($recommended_products)) {
        echo '<div class="tohju_bot_recommended_products wp-block-woocommerce-related-products alignwide">';
        echo '<h2>Recommended Products</h2>';
        echo '<ul class="products">';

        foreach ($recommended_products as $product_id) {
          $product = wc_get_product($product_id);

          if ($product) {
            $image_url = wp_get_attachment_url($product->get_image_id());

            echo '<li class="product">';
            echo '<a href="' . esc_url($product->get_permalink()) . '">';
            echo '<img src="' . esc_url($image_url) . '" alt="' . esc_attr($product->get_name()) . '">';
            echo '</a>';
            echo '<a href="' . esc_url($product->get_permalink()) . '">' . esc_html($product->get_name()) . '</a>';
            // echo '<span class="price">' . esc_html($product->get_price_html()) . '</span>';
            echo sprintf('<span class="price">%s</span>', wp_kses_post($product->get_price_html()));
            echo '</li>';
          }
        }

        echo '</ul>';
        echo '</div>';
      }
    } 
  }

  /**
   * Display recommended posts after post content
   */
  public function display_recommended_posts()
  {
    $output = ''; // Initialize an empty string to store the output

    if (get_option('tohju_bot_display_recommended_posts')) {
      // Get the list of recommended posts
      $recommended_posts = array_slice($this->tohju_bot_get_recommended_posts(), 0, 4);

      if (!empty($recommended_posts)) {
        $output .= '<div class="tohju_bot_recommended_posts">';
        $output .= '<h2>Recommended Posts</h2>';
        $output .= '<ul class="posts horizontal-posts">'; // Add horizontal-posts class

        foreach ($recommended_posts as $post) {
          $post_id = $post->ID;
          if ($post &&  is_singular() && in_the_loop() && is_main_query() ) {
            $image_url = get_the_post_thumbnail_url($post_id);
            if (empty($image_url)) {
              $image_url = plugins_url('assets/default-img.jpg', dirname(__FILE__) ); // Replace with your default image URL
            }
            $output .= '<li class="post">';
            $output .= '<a style="display: none" href="' . esc_url(get_permalink($post_id)) . '">';
            $output .= '<img src="' . esc_url($image_url) . '" alt="' . esc_attr(($post->post_title)) . '">';
            $output .= '</a>';
            $output .= '<h3 class="entry-title"><a href="' . esc_url(get_permalink($post_id)) . '">' . esc_html(get_the_title($post_id)) . '</a></h3>';
            $output .= '<span class="excerpt">' . esc_html( 
              strip_shortcodes( 
                strip_tags(
                  wp_trim_words($post->post_content, 50 ) 
                )
              ) 
              ) . '</span>';
            $output .= '</li>';
          }
        }

        $output .= '</ul>';
        $output .= '</div>';
      }
    }

    return $output;
  }

}