<?php
class Tohju_Indexer
{

  private $db;

  public function __construct()
  {
    $this->db = new Tohju_Bot_Db_Handler();
  }

  // Method to index all products
  public function index_all_products()
  {
    // Fetch all products (Example: using WooCommerce)
    $args = array(
      'post_type' => 'product',
      'posts_per_page' => -1 // fetch all products
    );
    $products = get_posts($args);

    // Safety check
    if (is_array($products) && !empty($products)) {
      $this->index_items($products);
    }
  }

  // Method to index all posts
  public function index_all_posts()
  {
    // Fetch all posts
    $args = array(
      'post_type' => 'post',
      'posts_per_page' => -1 // fetch all posts
    );
    $posts = get_posts($args);

    $this->index_items($posts);
    // Safety check
  }

  // Stub for the index function
  private function index_items($posts)
  {

    global $wp;
    $current_domain = $_SERVER['HTTP_HOST'];

    $namespace = tohju_bot_get_namespace($posts[0]->post_type);

    $has_data = $this->db->get_data($namespace);

    if (count($has_data) > 0) {
      $this->delete_all_vectors($posts[0]->post_type, $has_data);
    }
      
    $body = [
      "vectors" => [],
      "model" => TOHJU_BOT_CF_EMBEDDING_MODEL
    ];


    if (is_array($posts) && !empty($posts)) {
      foreach ($posts as $item) {
        $body['vectors'][] = [
          "text" => $item->post_title . ' ' . mb_substr($item->post_content, 0, 600),
          "metadata" => [
            "post_type" => $item->post_type,
            "post_ID" => $item->ID,
            "wp_domain" => $current_domain
          ]
        ];
      }
    }

    $json_body = json_encode($body);
    $url = TOHJU_BOT_CF_WORKER_URL . "/api/namespaces/$namespace/insert";

    $data = array(
      'timeout' => 60,
      'body' => $json_body,
      'headers' => array(
        'Content-Type' => 'application/json',  // Set content type to JSON
      ),
    );

    // Send POST request
    $response = wp_remote_post($url, $data);

    // Check for errors
    if (is_wp_error($response)) {
      $error_message = $response->get_error_message();
      echo esc_html("Something went wrong: $error_message\n");
    } else {
      $status_code = wp_remote_retrieve_response_code($response);
      if ($status_code !== 200) {
        echo esc_html("Something went wrong:");
        return;
      }
      $response_body = wp_remote_retrieve_body($response);

      // You can now use $body as needed, for example:
      $data = json_decode($response_body, true);
      
      $vectors = array_map(function ($vector) {
        return $vector['id'];
      }, $data['vectors'] );

      // check existing data
      if (count($has_data) === 0) {
        $this->db->insert_data($namespace, $vectors);
      } else {
        $this->db->update_data($vectors, $namespace, $has_data[0]->id);
      }
      echo esc_html($data['success']);
    }
  }

  public function delete_all_vectors($post_type, $has_data = false)
  {

    $namespace = tohju_bot_get_namespace($post_type);
    if (!$has_data) {
      $has_data = $this->db->get_data($namespace);
    }

    if (count($has_data) > 0) {
      $url = TOHJU_BOT_CF_WORKER_URL . "/api/namespaces/$namespace/vectors";
      $body = [
        "vectors" => json_decode($has_data[0]->ids),
      ];
      $json_body = json_encode($body);
      $data = array(
        'body' => $json_body,
        'headers' => array(
          'Content-Type' => 'application/json',  // Set content type to JSON
        ),
        'method' => 'DELETE'
      );
  
      // Send POST request
      $response = wp_remote_request($url, $data);

      if (is_wp_error($response)) {
        $error_message = $response->get_error_message();
        echo esc_html("Something went wrong: $error_message\n");
        return;
      } else {
        $status_code = wp_remote_retrieve_response_code($response);
        $response_body = wp_remote_retrieve_body($response);

        if ($status_code !== 200) {
          echo esc_html("Something went wrong:");
          return;
        }
      }
    }
  }

  public function delete_all_data()
  {
    $this->delete_all_vectors('post');
    $this->delete_all_vectors('product');

    $this->db->delete_data();
    echo "done";
  }

}

