<?php

class Tohju_Bot_Db_Handler
{
  private $table_name;

  public function __construct()
  {
    $this->table_name = TOHJU_BOT_DB_TABLE_NAME;
  }

  // Methods for CRUD operations will be added here
  public function get_data($index_type)
  {
    global $wpdb;

    $table_name = $wpdb->prefix . $this->table_name;

    $query = "SELECT * FROM $table_name WHERE index_type = %s";

    try {
      $results = $wpdb->get_results($wpdb->prepare($query, $index_type)); //db call ok; no-cache ok
    } catch (Exception $e) {
      // Handle the error
      error_log("Error retrieving data: " . $e->getMessage());
      return array();
    }

    return $results;
  }

  public function delete_table()
  {
    global $wpdb;

    $table_name = $wpdb->prefix . $this->table_name;

    $wpdb->query("DROP TABLE IF EXISTS $table_name"); //db call ok; no-cache ok
  }

  public function delete_data()
  {
    global $wpdb;

    $table_name = $wpdb->prefix . $this->table_name;

    $wpdb->query("TRUNCATE TABLE $table_name"); //db call ok; no-cache ok
  }

  public function create_table()
  {
    global $wpdb;

    $table_name = $wpdb->prefix . sanitize_sql_orderby($this->table_name);

    // Check if the table exists
    if ($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
      // Table does not exist, create it
      $charset_collate = $wpdb->get_charset_collate();

      $sql = "CREATE TABLE $table_name (
            id int(11) NOT NULL AUTO_INCREMENT,
            index_type varchar(20) NOT NULL,
            ids json NOT NULL,
            created_at datetime NOT NULL,
            PRIMARY KEY (id)
        ) $charset_collate;";

      try {
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql); //db call ok; no-cache ok
      } catch (Exception $e) {
        // Handle the error
        error_log("Error creating table: " . $e->getMessage());
      }
    } else {
      // Table exists, do nothing
    }
  }

  public function insert_data($index_type, $ids)
  {
    global $wpdb;

    $table_name = $wpdb->prefix . $this->table_name;

    $data = array(
      'index_type' => $index_type,
      'ids' => json_encode($ids),
      'created_at' => current_time('mysql')
    );

    $wpdb->insert($table_name, $data);
  }

  public function update_data($ids, $index_type, $db_record_id)
  {
    global $wpdb;

    $table_name = $wpdb->prefix . $this->table_name;

    $data = array(
      'ids' => json_encode($ids),
      'index_type' => $index_type
    );

    $wpdb->update($table_name, $data, [
      'id' => $db_record_id
    ]);
  }


}