<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://github.com/k0d3d
 * @since      1.0.0
 *
 * @package    Tohju_Bot
 * @subpackage Tohju_Bot/admin/partials
 */

if (!defined('ABSPATH'))
  exit;


?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<div class="wrap">
  <h1>Tohju AI Shopping Assistant Settings</h1>
  <?php tohju_indexer_page(); ?>
  <h3>Shopping Assistant AI Agent</h3>
  <form method="post" action="options.php">
    <?php settings_fields('tohju_bot_settings_group'); ?>
    <?php do_settings_sections('tohju_bot_settings_group'); ?>
    <table class="form-table">
      <tr valign="top">
        <th scope="row">Enter URL</th>
        <td><input type="text" name="tohju_bot_url" value="<?php echo esc_attr(get_option('tohju_bot_url')); ?>"
            class="regular-text" /></td>
      </tr>
      <tr valign="top">
        <th scope="row">Enable Recommended Products:</th>
        <td><input type="checkbox" name="tohju_bot_display_recommended_products" value="1" <?php checked(get_option('tohju_bot_display_recommended_products'), 1); ?> /></td>
      </tr>
      <tr valign="top">
        <th scope="row">Enable Recommended Posts:</th>
        <td><input type="checkbox" name="tohju_bot_display_recommended_posts" value="1" <?php checked(get_option('tohju_bot_display_recommended_posts'), 1); ?> /></td>
      </tr>
      <tr valign="top">
        <th scope="row">Create an AI Agent</th>
        <td>
          <a href="https://youtu.be/Jf0fDEyk_xc" target="_blank">Watch Video</a>
        </td>
      </tr>
      <tr valign="top">
        <th scope="row">Register now</th>
        <td>
          <a href="https://app.tohju.com/register" target="_blank">Get $5 Free</a>
        </td>
      </tr>
      <tr valign="top">
        <th scope="row">Need a feature?</th>
        <td>
          <a href="mailto:support@tohju.com" target="_blank">Email Us</a>
        </td>
      </tr>
    </table>
    <?php submit_button(); ?>
  </form>
</div>