(function( $ ) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

	function showMessage(message, type) {
		const messageDiv = $('#message');
		messageDiv
			.text(message)
			.removeClass('success error')
			.addClass(type);
	}

	jQuery(document).ready(function ($) {
		// Bind click events to the buttons
		$('#delete-all-data').click(function () {
			showMessage('Processing request...', '');
			$.ajax({
				type: 'POST',
				url: tohju_admin.ajax_url, // Use the WordPress AJAX endpoint
				data: {
					'action': 'tohju_delete_all_data' // Action hook
				},
				success: function (data) {
					console.log(data); // Log the response
					showMessage('Successfully deleted all posts and product data.', 'success');
				},
				error: function () {
					showMessage('Failed to delete data.', 'error');
				}
			});
		});

		// Bind click events to the buttons
		$('#index-all-posts').click(function () {
			showMessage('Processing request...', '');
			$.ajax({
				type: 'POST',
				url: tohju_admin.ajax_url, // Use the WordPress AJAX endpoint
				data: {
					'action': 'tohju_index_all_posts' // Action hook
				},
				success: function (data) {
					console.log(data); // Log the response
					showMessage('Successfully indexed all posts.', 'success');
				},
				error: function () {
					showMessage('Failed to index posts.', 'error');
				}
			});
		});
	
		$('#index-all-products').click(function () {
			showMessage('Processing request...', '');
			$.ajax({
				type: 'POST',
				url: tohju_admin.ajax_url, // Use the WordPress AJAX endpoint
				data: {
					'action': 'tohju_index_all_products' // Action hook
				},
				success: function (data) {
					console.log(data); // Log the response
					showMessage('Successfully indexed all products.', 'success');
				},
				error: function () {
					showMessage('Failed to index products.', 'error');
				}
			});
		});
	});


})( jQuery );
