<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://github.com/k0d3d
 * @since      1.0.0
 *
 * @package    Tohju_Bot
 * @subpackage Tohju_Bot/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Tohju_Bot
 * @subpackage Tohju_Bot/admin
 * @author     Tohju Dev <support@tohju.com>
 */
class Tohju_Bot_Admin
{

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct($plugin_name, $version)
	{

		$this->plugin_name = $plugin_name;
		$this->version = $version;

		$this->init_indexer();
		$this->init_admin_menu();

	}

	private function init_indexer()
	{
		$indexer = new Tohju_Indexer();

		// Ajax action hooks
		add_action('wp_ajax_tohju_index_all_posts', array($indexer, 'index_all_posts'));
		add_action('wp_ajax_tohju_delete_all_data', array($indexer, 'delete_all_data'));
		add_action('wp_ajax_tohju_index_all_products', array($indexer, 'index_all_products'));
		// add_action('wp_ajax_nopriv_tohju_index_all_posts', array($indexer, 'index_all_posts'));
		// add_action('wp_ajax_nopriv_tohju_index_all_products', array($indexer, 'index_all_products'));
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles()
	{

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Tohju_Bot_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Tohju_Bot_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/tohju-bot-admin.css', array(), $this->version, 'all');

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts()
	{

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Tohju_Bot_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Tohju_Bot_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/tohju-bot-admin.js', array('jquery'), $this->version, false);
		// Use wp_localize_script to pass the AJAX URL to the script
		wp_localize_script($this->plugin_name, 'tohju_admin', array(
			'ajax_url' => admin_url('admin-ajax.php')
		));
	}

	public function init_admin_menu()
	{

    function tohju_bot_register_settings()
    {
        register_setting('tohju_bot_settings_group', 'tohju_bot_url', array(
            'type' => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'default' => NULL,
        ));

        register_setting('tohju_bot_settings_group', 'tohju_bot_display_recommended_products', array(
            'type' => 'boolean',
            'sanitize_callback' => 'sanitize_text_field',
            'default' => false,
        ));

        register_setting('tohju_bot_settings_group', 'tohju_bot_display_recommended_posts', array(
            'type' => 'boolean',
            'sanitize_callback' => 'sanitize_text_field',
            'default' => false,
        ));
    }
		
		add_action('admin_init', 'tohju_bot_register_settings');

		function tohju_bot_settings_page()
		{
			include plugin_dir_path(__FILE__) . 'partials/tohju-bot-admin-display.php';
		}


		function tohju_bot_add_settings_menu()
		{
			add_options_page('Tohju AI Assistant Settings', 'Tohju AI', 'manage_options', 'tohju-bot-settings', 'tohju_bot_settings_page');
		}
		add_action('admin_menu', 'tohju_bot_add_settings_menu');
	}

}
