<?php
/**
 * Settings Page Template
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

if ( ! isset( $tcvs_settings ) || ! is_object( $tcvs_settings ) ) {
    $tcvs_settings = (object) array(
        'institute_name'    => '',
        'institute_logo'    => '',
        'institute_address' => '',
        'institute_phone'   => '',
        'institute_email'   => '',
        'signature_image'   => '',
        'verified_by_image' => '', 
    );
}

if (!isset($tcvs_settings->verified_by_image)) {
    $tcvs_settings->verified_by_image = '';
}

wp_enqueue_media();
?>

<div class="tcvs-admin-wrapper">
    <div class="tcvs-header-title">
        <span><?php esc_html_e( 'Institute Settings', 'tohidul-certificate-verification-system' ); ?></span>
        <button type="submit" form="tcvs-settings-form" class="button button-primary button-large">
            <?php esc_html_e( 'Save Changes', 'tohidul-certificate-verification-system' ); ?>
        </button>
    </div>
    
    <?php 
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    $tcvs_message = isset( $_GET['message'] ) ? sanitize_text_field( wp_unslash( $_GET['message'] ) ) : ''; 
    if ( 'saved' === $tcvs_message ) : ?>
        <div class="notice notice-success is-dismissible" style="margin-left: 0; margin-bottom: 20px;">
            <p><strong><?php esc_html_e( 'Success:', 'tohidul-certificate-verification-system' ); ?></strong> <?php esc_html_e( 'Settings saved successfully!', 'tohidul-certificate-verification-system' ); ?></p>
        </div>
    <?php 
    elseif ( 'error' === $tcvs_message ) : ?>
        <div class="notice notice-error is-dismissible" style="margin-left: 0; margin-bottom: 20px;">
            <p><strong><?php esc_html_e( 'Error:', 'tohidul-certificate-verification-system' ); ?></strong> <?php esc_html_e( 'Could not save settings. Please check all fields.', 'tohidul-certificate-verification-system' ); ?></p>
        </div>
    <?php endif; ?>
    
    <form id="tcvs-settings-form" method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
        <?php wp_nonce_field( 'tcvs_save_institute_settings', '_wpnonce' ); ?>
        <input type="hidden" name="action" value="tcvs_save_institute_settings">
        
        <div class="tcvs-form-grid">
            <div class="tcvs-col-main">
                <div class="tcvs-content-card">
                    <div class="tcvs-card-header">
                        <h2><span class="dashicons dashicons-building"></span> General Information</h2>
                    </div>
                    <div class="tcvs-card-body">
                        <div class="tcvs-form-group">
                            <label for="institute_name"><?php esc_html_e( 'Institute Name', 'tohidul-certificate-verification-system' ); ?> <span class="required">*</span></label>
                            <input type="text" id="institute_name" name="institute_name" value="<?php echo esc_attr( $tcvs_settings->institute_name ); ?>" placeholder="e.g. Dhaka Technical Institute" required>
                        </div>
                        <div class="tcvs-form-group">
                            <label for="institute_address"><?php esc_html_e( 'Institute Address', 'tohidul-certificate-verification-system' ); ?></label>
                            <textarea id="institute_address" name="institute_address" rows="3"><?php echo esc_textarea( $tcvs_settings->institute_address ); ?></textarea>
                        </div>
                        <div style="display: flex; gap: 20px;">
                            <div class="tcvs-form-group" style="flex: 1;">
                                <label for="institute_phone"><?php esc_html_e( 'Phone Number', 'tohidul-certificate-verification-system' ); ?></label>
                                <input type="text" id="institute_phone" name="institute_phone" value="<?php echo esc_attr( $tcvs_settings->institute_phone ); ?>">
                            </div>
                            <div class="tcvs-form-group" style="flex: 1;">
                                <label for="institute_email"><?php esc_html_e( 'Email Address', 'tohidul-certificate-verification-system' ); ?></label>
                                <input type="email" id="institute_email" name="institute_email" value="<?php echo esc_attr( $tcvs_settings->institute_email ); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tcvs-col-side">
                <div class="tcvs-content-card">
                    <div class="tcvs-card-header">
                        <h2>Institute Logo</h2>
                    </div>
                    <div class="tcvs-card-body">
                        <div class="tcvs-image-upload-area">
                            <div id="logo_preview" class="tcvs-image-preview-box">
                                <?php if ( ! empty( $tcvs_settings->institute_logo ) ) : ?>
                                    <div class="tcvs-image-preview-wrapper"><img src="<?php echo esc_url( $tcvs_settings->institute_logo ); ?>" alt="Logo"></div>
                                <?php else: ?>
                                    <div class="tcvs-placeholder"><span class="dashicons dashicons-format-image"></span><p>No logo set</p></div>
                                <?php endif; ?>
                            </div>
                            <input type="hidden" id="institute_logo" name="institute_logo" value="<?php echo esc_url( $tcvs_settings->institute_logo ); ?>">
                            <div class="tcvs-upload-actions">
                                <button type="button" class="button tcvs-media-select tcvs-full-width-btn" data-target="institute_logo" data-preview="logo_preview">
                                    <?php echo empty($tcvs_settings->institute_logo) ? 'Upload Logo' : 'Change Logo'; ?>
                                </button>
                                <?php if(!empty($tcvs_settings->institute_logo)): ?>
                                    <button type="button" class="button button-link-delete tcvs-media-remove" data-target="institute_logo" data-preview="logo_preview" style="color: #a00; margin-top: 5px;">Remove</button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tcvs-content-card">
                    <div class="tcvs-card-header">
                        <h2>Authorized Signature</h2>
                    </div>
                    <div class="tcvs-card-body">
                        <div class="tcvs-image-upload-area">
                            <div id="signature_preview" class="tcvs-image-preview-box">
                                <?php if ( ! empty( $tcvs_settings->signature_image ) ) : ?>
                                    <div class="tcvs-image-preview-wrapper"><img src="<?php echo esc_url( $tcvs_settings->signature_image ); ?>" alt="Signature"></div>
                                <?php else: ?>
                                    <div class="tcvs-placeholder"><span class="dashicons dashicons-pen"></span><p>No signature</p></div>
                                <?php endif; ?>
                            </div>
                            <input type="hidden" id="signature_image" name="signature_image" value="<?php echo esc_url( $tcvs_settings->signature_image ); ?>">
                            <div class="tcvs-upload-actions">
                                <button type="button" class="button tcvs-media-select" data-target="signature_image" data-preview="signature_preview" style="width:100%;">Upload Signature</button>
                                <?php if(!empty($tcvs_settings->signature_image)): ?>
                                    <button type="button" class="button button-link-delete tcvs-media-remove" data-target="signature_image" data-preview="signature_preview" style="color: #a00; margin-top: 5px;">Remove</button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tcvs-content-card">
                    <div class="tcvs-card-header">
                        <h2>Verified By (Seal)</h2>
                    </div>
                    <div class="tcvs-card-body">
                        <div class="tcvs-image-upload-area">
                            <div id="verified_preview" class="tcvs-image-preview-box">
                                <?php if ( ! empty( $tcvs_settings->verified_by_image ) ) : ?>
                                    <div class="tcvs-image-preview-wrapper"><img src="<?php echo esc_url( $tcvs_settings->verified_by_image ); ?>" alt="Seal"></div>
                                <?php else: ?>
                                    <div class="tcvs-placeholder"><span class="dashicons dashicons-awards"></span><p>No seal</p></div>
                                <?php endif; ?>
                            </div>
                            <input type="hidden" id="verified_by_image" name="verified_by_image" value="<?php echo esc_url( $tcvs_settings->verified_by_image ); ?>">
                            <div class="tcvs-upload-actions">
                                <button type="button" class="button tcvs-media-select" data-target="verified_by_image" data-preview="verified_preview" style="width:100%;">Upload Seal</button>
                                <?php if(!empty($tcvs_settings->verified_by_image)): ?>
                                    <button type="button" class="button button-link-delete tcvs-media-remove" data-target="verified_by_image" data-preview="verified_preview" style="color: #a00; margin-top: 5px;">Remove</button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>