<?php
/**
 * Add/Edit Certificate Form Template
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$tcvs_id                 = isset( $certificate->id ) ? $certificate->id : 0;
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$tcvs_student_name       = isset( $certificate->student_name ) ? $certificate->student_name : '';
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$tcvs_father_name        = isset( $certificate->father_name ) ? $certificate->father_name : '';
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$tcvs_certificate_number = isset( $certificate->certificate_number ) ? $certificate->certificate_number : '';
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$tcvs_batch_number       = isset( $certificate->batch_number ) ? $certificate->batch_number : '';
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$tcvs_course_name        = isset( $certificate->course_name ) ? $certificate->course_name : '';
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$tcvs_issue_date         = ( ! empty( $certificate->issue_date ) && $certificate->issue_date !== '0000-00-00' ) ? $certificate->issue_date : current_time('Y-m-d');
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
$tcvs_student_image      = isset( $certificate->student_image ) ? $certificate->student_image : '';

?>

<div class="tcvs-admin-wrapper">
    <div class="tcvs-header-title">
        <span><span class="dashicons dashicons-welcome-add-page" style="font-size: 28px; width: 28px; height: 28px; margin-right: 10px; vertical-align: middle;"></span> <?php echo esc_html( $form_title ); ?></span>
        <a href="<?php echo esc_url( admin_url( 'admin.php?page=certificate-verification' ) ); ?>" class="button button-secondary">
            <span class="dashicons dashicons-arrow-left-alt" style="vertical-align: middle;"></span> <?php esc_html_e( 'Back to List', 'tohidul-certificate-verification-system' ); ?>
        </a>
    </div>

    <form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
        <?php wp_nonce_field( $form_action, 'tcvs_certificate_nonce' ); ?>
        <input type="hidden" name="action" value="<?php echo esc_attr( $form_action ); ?>">
        <?php if ( $is_edit ) : ?>
            <input type="hidden" name="certificate_id" value="<?php echo esc_attr( $tcvs_id ); ?>">
        <?php endif; ?>

        <div class="tcvs-form-container">
            <div class="tcvs-left-col">
                <div class="tcvs-card">
                    <div class="tcvs-card-header">
                        <h3><span class="dashicons dashicons-id" style="vertical-align: text-top;"></span> Student Information</h3>
                    </div>
                    
                    <div class="tcvs-form-group">
                        <label for="student_name"><?php esc_html_e( 'Student Name', 'tohidul-certificate-verification-system' ); ?> <span class="required" style="color:red;">*</span></label>
                        <input type="text" name="student_name" id="student_name" value="<?php echo esc_attr( $tcvs_student_name ); ?>" placeholder="Enter full name" required>
                    </div>

                    <div class="tcvs-form-group">
                        <label for="father_name"><?php esc_html_e( 'Father\'s Name', 'tohidul-certificate-verification-system' ); ?> <span class="required" style="color:red;">*</span></label>
                        <input type="text" name="father_name" id="father_name" value="<?php echo esc_attr( $tcvs_father_name ); ?>" placeholder="Enter father's name" required>
                    </div>
                </div>

                <div class="tcvs-card">
                    <div class="tcvs-card-header">
                        <h3><span class="dashicons dashicons-welcome-learn-more" style="vertical-align: text-top;"></span> Course Details</h3>
                    </div>

                    <div class="tcvs-form-group">
                        <label for="course_name"><?php esc_html_e( 'Course Name', 'tohidul-certificate-verification-system' ); ?> <span class="required" style="color:red;">*</span></label>
                        <input type="text" name="course_name" id="course_name" value="<?php echo esc_attr( $tcvs_course_name ); ?>" placeholder="e.g. Graphic Design & Multimedia" required>
                    </div>

                    <div class="tcvs-form-row">
                        <div class="tcvs-form-group">
                            <label for="certificate_number"><?php esc_html_e( 'Registration / Reg. No', 'tohidul-certificate-verification-system' ); ?> <span class="required" style="color:red;">*</span></label>
                            <input type="text" name="certificate_number" id="certificate_number" value="<?php echo esc_attr( $tcvs_certificate_number ); ?>" placeholder="e.g. 202301001" required>
                        </div>
                        <div class="tcvs-form-group">
                            <label for="batch_number"><?php esc_html_e( 'Batch No', 'tohidul-certificate-verification-system' ); ?> <span class="required" style="color:red;">*</span></label>
                            <input type="text" name="batch_number" id="batch_number" value="<?php echo esc_attr( $tcvs_batch_number ); ?>" placeholder="e.g. B-25" required>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tcvs-right-col">
                <div class="tcvs-card" style="padding: 0;">
                    <div style="padding: 20px; border-bottom: 1px solid #eee;">
                        <h3><span class="dashicons dashicons-calendar-alt" style="vertical-align: text-top;"></span> Publishing</h3>
                    </div>
                    <div style="padding: 20px;">
                        <div class="tcvs-form-group">
                            <label for="issue_date"><?php esc_html_e( 'Issue Date', 'tohidul-certificate-verification-system' ); ?></label>
                            <input type="date" name="issue_date" id="issue_date" value="<?php echo esc_attr( $tcvs_issue_date ); ?>" style="width:100%;">
                        </div>
                    </div>
                    <div class="tcvs-submit-card">
                        <button type="submit" class="button-tcvs-primary">
                            <span class="dashicons dashicons-saved" style="vertical-align: text-top;"></span> <?php echo esc_html( $button_text ); ?>
                        </button>
                    </div>
                </div>

                <div class="tcvs-card">
                    <div class="tcvs-card-header">
                        <h3><span class="dashicons dashicons-format-image" style="vertical-align: text-top;"></span> Student Photo</h3>
                    </div>
                    <div class="tcvs-image-upload-box">
                        <div id="student_image_preview" class="tcvs-image-preview">
                            <?php if ( ! empty( $tcvs_student_image ) ) : ?>
                                <img src="<?php echo esc_url( $tcvs_student_image ); ?>" alt="Preview">
                            <?php else : ?>
                                <span class="dashicons dashicons-format-gallery tcvs-placeholder-icon"></span>
                                <p style="color:#888; font-size:13px; margin:0;"><?php esc_html_e( 'No image selected', 'tohidul-certificate-verification-system' ); ?></p>
                            <?php endif; ?>
                        </div>
                        <input type="hidden" name="student_image" id="student_image" value="<?php echo esc_url( $tcvs_student_image ); ?>">
                        <button type="button" class="button button-secondary tcvs-media-select" data-target="student_image" data-preview="student_image_preview" style="margin-top: 15px;">
                            <?php esc_html_e( 'Choose Image', 'tohidul-certificate-verification-system' ); ?>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>